/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.conformation;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.NumberFormatter;
import com.equestricraft.core.conformation.check.ConformationCheckResult;
import com.equestricraft.core.conformation.measurement.ConformationMeasurement;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementRepository;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurement;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurementRepository;
import com.equestricraft.mod.horse.conformation.HorseConformationCheckInfo;
import com.equestricraft.mod.horse.conformation.HorseConformationMeasurementInfo;
import com.equestricraft.mod.horse.conformation.HorseConformationService;
import com.equestricraft.mod.packet.ClientBoundHorseConformationCheckScreenOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseConformationMeasurementsScreenOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HorseConformationServiceImpl
implements HorseConformationService {
    @Service
    private HorseConformationMeasurementRepository horseConformationMeasurementRepository;
    @Service
    private ConformationMeasurementRepository conformationMeasurementRepository;
    @Service
    private HorseTransformer horseTransformer;

    @Override
    public void showConformationMeasurementsScreen(OnlinePlayer player, int horseId) {
        List<HorseConformationMeasurementInfo> infoList = this.getAllMeasurementsForHorse(horseId);
        ClientBoundHorseConformationMeasurementsScreenOpenPacket packet = new ClientBoundHorseConformationMeasurementsScreenOpenPacket(horseId, infoList);
        player.sendPacket(packet);
    }

    private List<HorseConformationMeasurementInfo> getAllMeasurementsForHorse(int horseId) {
        List<HorseConformationMeasurement> parts = this.horseConformationMeasurementRepository.findAllMeasurementsForHorse(horseId);
        return parts.stream().map(this::buildInfo).toList();
    }

    private HorseConformationMeasurementInfo buildInfo(HorseConformationMeasurement horseMeasurement) {
        ConformationMeasurement measurement = (ConformationMeasurement)this.conformationMeasurementRepository.findByKey(horseMeasurement.getMeasurementId());
        return new HorseConformationMeasurementInfo(measurement.getId(), measurement.getType(), measurement.getName(), NumberFormatter.format2DP(horseMeasurement.getValue()) + measurement.getUnit());
    }

    @Override
    public void showConformationCheckScreen(OnlinePlayer player, EQHorse horse) {
        List<HorseConformationCheckInfo> infoList = this.getAllChecksForHorse(horse);
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        ClientBoundHorseConformationCheckScreenOpenPacket packet = new ClientBoundHorseConformationCheckScreenOpenPacket(simple, infoList);
        player.sendPacket(packet);
    }

    @NotNull
    private List<HorseConformationCheckInfo> getAllChecksForHorse(EQHorse horse) {
        ArrayList<HorseConformationCheckInfo> infoList = new ArrayList<HorseConformationCheckInfo>(ConformationCheckType.values().length);
        for (ConformationCheckType type : ConformationCheckType.values()) {
            ConformationCheckResult result = horse.getConformation().getCheckResult(type);
            HorseConformationCheckInfo info2 = new HorseConformationCheckInfo(result.check().getName(), result.check().getDescription(), result.conformationCheckRating(), this.getStatImpairmentValue(result.speedPercentage()), this.getStatImpairmentValue(result.jumpPercentage()), this.getStatImpairmentValue(result.staminaPercentage()));
            infoList.add(info2);
        }
        return infoList;
    }

    private int getStatImpairmentValue(double percentage) {
        if (percentage > 100.0) {
            return 1;
        }
        if (percentage < 100.0) {
            return -1;
        }
        return 0;
    }
}

