/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.create;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatModifiers;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.HorseOrigin;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.breed.BreedInfo;
import com.equestricraft.core.breed.BreedRepository;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.breed.HorseBreedInfoDefinition;
import com.equestricraft.core.horse.coat.HorseCoatSession;
import com.equestricraft.core.horse.create.HorseCreateBreedRequest;
import com.equestricraft.core.horse.create.HorseCreateException;
import com.equestricraft.core.horse.create.HorseCreateRequest;
import com.equestricraft.core.horse.create.HorseCreateSession;
import com.equestricraft.core.horse.create.ValidHorseCreateSelections;
import com.equestricraft.core.namegenerator.NameGeneratorSession;
import com.equestricraft.core.player.token.NotEnoughTokensException;
import com.equestricraft.mod.horse.create.HorseCreateMenuService;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.packet.ClientBoundHorseCreateBreedUpdatePacket;
import com.equestricraft.mod.packet.ClientBoundHorseCreateMenuClearPacket;
import com.equestricraft.mod.packet.ClientBoundHorseCreateMenuPacket;
import com.equestricraft.mod.packet.ClientBoundHorseCreateValidSelectionsUpdatePacket;
import com.equestricraft.mod.packet.ClientBoundSetHorseCreateNameFieldPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class HorseCreateMenuServiceImpl
implements HorseCreateMenuService {
    @Service
    private HorseCreateSession horseCreateSession;
    @Service
    private StandardHorseEntitySession standardHorseEntitySession;
    @Service
    private NameGeneratorSession nameGeneratorSession;
    @Service
    private HorseCoatSession horseCoatSession;
    @Service
    private BreedRepository breedRepository;

    @Override
    public Response showHorseCreateMenuToPlayer(OnlinePlayer player) {
        Integer tokenBalance;
        Integer n = tokenBalance = player.getPermission().hasPermission("equestricraft.horse.bypass-tokens") ? null : Integer.valueOf(player.getTokens().getHorseCreateTokenCount());
        if (tokenBalance != null && tokenBalance <= 0) {
            return ResponseFactory.fail(I18n.getLabel("horse-create.menu.title"), I18n.getLabel("horse-create.menu.not-enough-tokens"));
        }
        ClientBoundHorseCreateMenuPacket packet = new ClientBoundHorseCreateMenuPacket(tokenBalance);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response requestRandomName(OnlinePlayer player) {
        String name = this.nameGeneratorSession.getRandomName();
        ClientBoundSetHorseCreateNameFieldPacket packet = new ClientBoundSetHorseCreateNameFieldPacket(name);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response processHorseCreateMenuCreate(OnlinePlayer player, String name, HorseGender gender, int ageMonths, HorseCoatColor color, HorseCoatModifiers modifiers, int breedId, double height) {
        HorseCreateRequest request = HorseCreateRequest.Builder.start().withOrigin(HorseOrigin.CUSTOM).withName(name).withOwner(player).withGender(gender).withAgeMonths(ageMonths).withCoatDetails(this.horseCoatSession.buildCoatDetails(color, modifiers)).withFinalHeight(height).complete();
        try {
            int tokenBalance = player.getTokens().getHorseCreateTokenCount();
            boolean bypassTokens = player.getPermission().hasPermission("equestricraft.horse.bypass-tokens");
            if (!bypassTokens && tokenBalance <= 0) {
                throw new HorseCreateException(I18n.getLabel("horse.create.no-tokens-left"));
            }
            EQHorse horse = this.horseCreateSession.createHorse(request);
            this.setHorseBreed(breedId, horse);
            if (!bypassTokens) {
                this.withdrawToken(player);
            }
            ServerPlayer serverPlayer = player.serverPlayer();
            this.standardHorseEntitySession.spawnHorse(horse, (Entity)serverPlayer);
            this.clearHorseCreateMenu(player);
            return ResponseFactory.success();
        }
        catch (HorseCreateException ex) {
            return ResponseFactory.fail(I18n.getLabel("horse.create.fail.prompt.title"), ex);
        }
    }

    private void setHorseBreed(int breedId, EQHorse horse) {
        Breed breed = (Breed)this.breedRepository.findByKey(breedId);
        HorseBreedInfoDefinition breedInfo = new HorseBreedInfoDefinition(breed, 100.0);
        horse.getBreed().classify(Collections.singletonList(breedInfo));
    }

    @Override
    public Response requestValidBreedUpdates(OnlinePlayer player, HorseCreateBreedRequest request) {
        List<BreedInfo> breeds = this.horseCreateSession.getValidBreeds(request);
        ClientBoundHorseCreateBreedUpdatePacket packet = new ClientBoundHorseCreateBreedUpdatePacket(breeds);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response requestValidSelections(OnlinePlayer player, int breedId) {
        Breed breed = (Breed)this.breedRepository.findByKey(breedId);
        ValidHorseCreateSelections validSelections = this.horseCreateSession.getValidHorseCreateSelections(breed);
        ClientBoundHorseCreateValidSelectionsUpdatePacket packet = new ClientBoundHorseCreateValidSelectionsUpdatePacket(validSelections);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response requestAllAvailableBreeds(OnlinePlayer player) {
        List<BreedInfo> breeds = this.horseCreateSession.getAllCreateBreeds();
        ClientBoundHorseCreateBreedUpdatePacket packet = new ClientBoundHorseCreateBreedUpdatePacket(breeds);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    private void withdrawToken(OnlinePlayer player) throws HorseCreateException {
        try {
            player.getTokens().takeHorseCreateTokens(1);
        }
        catch (NotEnoughTokensException ex) {
            throw new HorseCreateException(ex);
        }
    }

    private void clearHorseCreateMenu(OnlinePlayer onlinePlayer) {
        ClientBoundHorseCreateMenuClearPacket packet = new ClientBoundHorseCreateMenuClearPacket();
        onlinePlayer.sendPacket(packet);
    }
}

