/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.dead;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.horse.dead.DeadHorseListItem;
import com.equestricraft.mod.horse.dead.DeadHorseListPage;
import com.equestricraft.mod.horse.dead.DeadHorsePageService;
import java.util.Comparator;
import java.util.List;

public class DeadHorsePageServiceImpl
extends Pagination<DeadHorseListItem, DeadHorseListPage, Object, String>
implements DeadHorsePageService {
    private static final int MAXIMUM_PER_PAGE = 4;

    @Override
    public DeadHorseListPage retrieveDeadHorseList(ECPlayer player, int pageNumber, String text) {
        List<DeadHorseListItem> items = player.getHorses().getDead().stream().map(this::buildItem).toList();
        return (DeadHorseListPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, text);
    }

    private DeadHorseListItem buildItem(EQHorse horse) {
        return new DeadHorseListItem(horse.getId(), horse.getName(), horse.getShowName(), (int)horse.getDeath().getDurationSince().toDays(), horse.isDeathRegistered());
    }

    @Override
    protected int getMaximumPerPage() {
        return 4;
    }

    @Override
    protected boolean filter(DeadHorseListItem item, String filterObject) {
        filterObject = filterObject.toLowerCase();
        return item.name().toLowerCase().contains(filterObject) || item.showName() != null && item.showName().toLowerCase().contains(filterObject);
    }

    @Override
    protected Comparator<DeadHorseListItem> compare(Object sortOrderObject) {
        return Comparator.comparing(DeadHorseListItem::daysSinceDeath);
    }

    @Override
    protected DeadHorseListPage buildPage(List<DeadHorseListItem> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, String filterObject) {
        return new DeadHorseListPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

