/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.dead;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.horse.dead.DeadHorseListPage;
import com.equestricraft.mod.horse.dead.DeadHorsePageService;
import com.equestricraft.mod.packet.ClientBoundDeadHorseSelectPromptOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class DeadHorseSelectPrompt {
    @Service
    private static DeadHorsePageService deadHorsePageService;
    private static final PromptResponsesHandler promptResponsesHandler;
    private static final Log log;

    public static Optional<EQHorse> showPrompt(OnlinePlayer onlinePlayer) {
        try {
            CompletableFuture<EQHorse> result = DeadHorseSelectPrompt.showPromptAsync(onlinePlayer);
            return Optional.ofNullable(result.get());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (ExecutionException ex) {
            log.error(String.format("Error with dead horse select prompt. Player: %s", onlinePlayer.getIgn()), ex);
            return Optional.empty();
        }
    }

    public static CompletableFuture<EQHorse> showPromptAsync(OnlinePlayer onlinePlayer) {
        PromptResponseHandler handler = promptResponsesHandler.initResponse(onlinePlayer);
        DeadHorseListPage page = deadHorsePageService.retrieveDeadHorseList(onlinePlayer, 1, "");
        ClientBoundDeadHorseSelectPromptOpenPacket packet = new ClientBoundDeadHorseSelectPromptOpenPacket(handler.uuid(), page);
        onlinePlayer.sendPacket(packet);
        return handler.future();
    }

    public static void changePage(OnlinePlayer onlinePlayer, UUID uuid, int pageNumber, String text) {
        DeadHorseListPage page = deadHorsePageService.retrieveDeadHorseList(onlinePlayer, pageNumber, text);
        ClientBoundDeadHorseSelectPromptOpenPacket packet = new ClientBoundDeadHorseSelectPromptOpenPacket(uuid, page);
        onlinePlayer.sendPacket(packet);
    }

    private DeadHorseSelectPrompt() {
    }

    static {
        promptResponsesHandler = PromptResponsesHandler.getInstance();
        log = Log.getLogger(DeadHorseSelectPrompt.class.getName());
    }
}

