/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.dead;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.horse.dead.DeadHorseSelectPrompt;
import com.equestricraft.mod.horse.dead.DeathCertificateService;
import com.equestricraft.mod.horse.dead.HorseDeathCertificate;
import com.equestricraft.mod.packet.ClientBoundHorseDeathCertificateMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

public class DeathCertificateServiceImpl
implements DeathCertificateService {
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public Response showDeathCertificateMenu(OnlinePlayer onlinePlayer) {
        if (FeatureFlag.DEATH_REGISTRATION.isDisabled()) {
            return ResponseFactory.fail();
        }
        Optional<EQHorse> horse = DeadHorseSelectPrompt.showPrompt(onlinePlayer);
        return horse.map(h -> this.showDeathCertificate(onlinePlayer, (EQHorse)h)).orElseGet(ResponseFactory::fail);
    }

    private Response showDeathCertificate(OnlinePlayer player, EQHorse horse) {
        if (!horse.isDeathRegistered()) {
            return ResponseFactory.fail(I18n.getLabel("horse.death-certificate.not-yet-registered.prompt.title"), I18n.getLabel("horse.death-certificate.not-yet-registered.prompt.message"));
        }
        HorseDeathCertificate certificate = this.buildCertificate(horse);
        ClientBoundHorseDeathCertificateMenuOpenPacket packet = new ClientBoundHorseDeathCertificateMenuOpenPacket(certificate);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    private HorseDeathCertificate buildCertificate(EQHorse horse) {
        return new HorseDeathCertificate(horse.getId(), horse.getName(), horse.getShowName(), this.playerTransformer.toSimple(horse.getOwner().getCorePlayer()), DateFormatter.formatDateFull(horse.getDeath().getTime()), horse.getDeath().getReason());
    }
}

