/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.details;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.command.UpdateHorseNameCommand;
import com.equestricraft.core.horse.command.UpdateHorsesCurrentValue;
import com.equestricraft.mod.horse.details.HorseDetailsUpdateService;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.NumberInputPrompt;
import com.equestricraft.mod.prompt.TextInputPrompt;
import java.util.Optional;

public class HorseDetailsUpdateServiceImpl
implements HorseDetailsUpdateService {
    @Service
    private HorseRepository horseRepository;

    @Override
    public Response updateHorseName(OnlinePlayer onlinePlayer, EQHorse horse) {
        Optional<String> name = TextInputPrompt.showTextInputPrompt(onlinePlayer, I18n.getLabel("horse.name.update.prompt.title"), I18n.getLabel("horse.name.update.prompt.message"));
        if (name.isPresent()) {
            return horse.getCommandExecutor().execute(new UpdateHorseNameCommand(onlinePlayer, name.get()));
        }
        return ResponseFactory.success();
    }

    @Override
    public void updateHorseName(OnlinePlayer onlinePlayer, int horseId, String postUpdateMenu) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Response response = this.updateHorseName(onlinePlayer, horse);
        if (postUpdateMenu != null) {
            if (response.isSuccess()) {
                onlinePlayer.getMenus().showHorseMenu(horse, postUpdateMenu);
            } else {
                onlinePlayer.showResponse(response);
                this.updateHorseName(onlinePlayer, horseId, postUpdateMenu);
            }
        } else {
            onlinePlayer.showResponse(response);
        }
    }

    @Override
    public Response updateHorseCurrentValue(OnlinePlayer onlinePlayer, EQHorse horse) {
        Optional<Number> newValue = NumberInputPrompt.showNumberInputPrompt(onlinePlayer, I18n.getLabel("horse.current-value.update.prompt.title"), I18n.getLabel("horse.current-value.update.prompt.message"));
        if (newValue.isPresent()) {
            return horse.getCommandExecutor().execute(new UpdateHorsesCurrentValue(onlinePlayer, newValue.get().doubleValue()));
        }
        return ResponseFactory.fail();
    }

    @Override
    public void updateHorseCurrentValue(OnlinePlayer onlinePlayer, int horseId, String postUpdateMenu) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Response response = this.updateHorseCurrentValue(onlinePlayer, horse);
        if (postUpdateMenu != null) {
            if (response.isSuccess()) {
                onlinePlayer.getMenus().showHorseMenu(horse, postUpdateMenu);
            } else {
                onlinePlayer.showResponse(response);
                this.updateHorseCurrentValue(onlinePlayer, horseId, postUpdateMenu);
            }
        } else {
            onlinePlayer.showResponse(response);
        }
    }
}

