/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.discipline;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.discipline.Discipline;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.horse.discipline.HorseDisciplineInfo;
import com.equestricraft.mod.horse.discipline.HorseDisciplineService;
import com.equestricraft.mod.packet.ClientBoundHorseDisciplineMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;

public class HorseDisciplineServiceImpl
implements HorseDisciplineService {
    @Service
    private HorseTransformer horseTransformer;

    @Override
    public void showHorsesDisciplinesMenu(OnlinePlayer player, EQHorse horse) {
        List<Discipline> disciplines = horse.getDisciplines().getCertified();
        List<HorseDisciplineInfo> infoList = disciplines.stream().map(this::buildInfo).toList();
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        ClientBoundHorseDisciplineMenuOpenPacket packet = new ClientBoundHorseDisciplineMenuOpenPacket(simple, FeatureFlag.DISCIPLINE_CERTIFICATION.isEnabled() ? horse.getLastDisciplineCertification() : null, infoList);
        player.sendPacket(packet);
    }

    private HorseDisciplineInfo buildInfo(Discipline discipline) {
        return new HorseDisciplineInfo(discipline.getId(), discipline.getName(), discipline.getDescription());
    }
}

