/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.entity;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.util.PredicateUtils;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.EntityInit;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.horse.cache.HorseCacheEntry;
import com.equestricraft.mod.horse.cache.HorseEntityCache;
import com.equestricraft.mod.horse.entity.HorseEntitySession;
import com.equestricraft.mod.horse.entity.HorseSpawnData;
import com.equestricraft.mod.util.BlockPosUtil;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;

public class HorseEntitySessionImpl
implements HorseEntitySession {
    private final HorseEntityCache horseEntityCache = HorseEntityCache.getInstance();
    private static final Log log = Log.getLogger(HorseEntitySessionImpl.class.getName());

    @Override
    public EntityHorse spawnHorse(int internalId, HorseEntityType entityType, Entity targetEntity, HorseSpawnData horseSpawnData, Consumer<EntityHorse> preSpawnAction) {
        DirectionalCoordinate directionalCoordinate = BlockPosUtil.toDirectionalCoordinate(targetEntity.m_20097_(), ServerLevelUtil.getEntitiesECLevel(targetEntity), targetEntity.m_146908_(), targetEntity.m_146909_());
        return this.spawnHorse(internalId, entityType, directionalCoordinate, horseSpawnData, preSpawnAction);
    }

    @Override
    public EntityHorse spawnHorse(int internalId, HorseEntityType entityType, DirectionalCoordinate directionalCoordinate, HorseSpawnData horseSpawnData, Consumer<EntityHorse> preSpawnAction) {
        BlockPos blockPos;
        EntityHorse entity;
        ServerLevel serverLevel = ServerLevelUtil.getServerLevel(directionalCoordinate.world());
        boolean added = TaskScheduler.executeAwaitSyncTask(() -> HorseEntitySessionImpl.lambda$spawnHorse$1(serverLevel, entity = TaskScheduler.executeAwaitSyncTask(() -> HorseEntitySessionImpl.lambda$spawnHorse$0(serverLevel, preSpawnAction, horseSpawnData, blockPos = BlockPosUtil.toBlockPos(directionalCoordinate), directionalCoordinate, entityType, internalId))));
        if (!added) {
            throw new IllegalArgumentException(String.format("Unable to spawn horse entity %s of type %s", internalId, entityType.name()));
        }
        return entity;
    }

    @Override
    public Optional<EntityHorse> findEntityForHorse(int internalId, HorseEntityType entityType) {
        for (ServerLevel level : ServerLevelUtil.getServerLevels()) {
            Optional<EntityHorse> entity = this.findEntityForHorse(internalId, entityType, level);
            if (!entity.isPresent()) continue;
            return entity;
        }
        return Optional.empty();
    }

    @Override
    public Optional<EntityHorse> findEntityForHorse(int internalId, HorseEntityType entityType, ServerLevel serverLevel) {
        try {
            ArrayList horseEntities = new ArrayList();
            serverLevel.m_8583_().forEach(e -> {
                if (e instanceof EntityHorse) {
                    EntityHorse entityHorse = (EntityHorse)e;
                    horseEntities.add(entityHorse);
                }
            });
            return horseEntities.stream().filter(e -> e.getHorseEntityType() == entityType && e.getInternalId() == internalId).findFirst();
        }
        catch (Exception ex) {
            log.error("Error finding entity for horse ID {} for type {} in level {}", new Object[]{internalId, entityType, serverLevel});
            return Optional.empty();
        }
    }

    @Override
    public EntityHorse teleportHorse(int internalId, HorseEntityType entityType, Entity targetEntity, Supplier<HorseSpawnData> horseSpawnDataSupplier, Consumer<EntityHorse> preSpawnAction) {
        DirectionalCoordinate directionalCoordinate = BlockPosUtil.toDirectionalCoordinate(targetEntity.m_20097_(), ServerLevelUtil.getEntitiesECLevel(targetEntity), targetEntity.m_146908_(), targetEntity.m_146909_());
        return this.teleportHorse(internalId, entityType, directionalCoordinate, horseSpawnDataSupplier, preSpawnAction);
    }

    @Override
    public EntityHorse teleportHorse(int internalId, HorseEntityType entityType, DirectionalCoordinate directionalCoordinate, Supplier<HorseSpawnData> horseSpawnDataSupplier, Consumer<EntityHorse> preSpawnAction) {
        ECLevel level = ECLevel.getByIdentifier(directionalCoordinate.world());
        if (entityType == HorseEntityType.STANDARD) {
            HorseCacheEntry e;
            Optional<HorseCacheEntry> entry = this.horseEntityCache.getEntityForHorse(internalId);
            if (entry.isPresent() && (e = entry.get()).active()) {
                if (e.getLevel().equals((Object)level)) {
                    Vec3 vec3 = new Vec3(directionalCoordinate.x(), directionalCoordinate.y() + 1.0, directionalCoordinate.z());
                    e.getEntity().m_146884_(vec3);
                    return e.getEntity();
                }
                this.horseEntityCache.removeEntityForHorse(internalId);
            }
        } else {
            ServerLevel serverLevel = ServerLevelUtil.getServerLevel(directionalCoordinate.world());
            Optional<EntityHorse> entityHorse = this.findEntityForHorse(internalId, entityType, serverLevel);
            if (entityHorse.isPresent()) {
                entityHorse.get().m_6034_(directionalCoordinate.x(), directionalCoordinate.y() + 1.0, directionalCoordinate.z());
                return entityHorse.get();
            }
            this.removeHorseFromAllLevels(internalId, entityType);
            return this.spawnHorse(internalId, entityType, directionalCoordinate, horseSpawnDataSupplier.get(), preSpawnAction);
        }
        this.removeHorseFromAllLevels(internalId, entityType);
        EntityHorse horse = this.spawnHorse(internalId, entityType, directionalCoordinate, horseSpawnDataSupplier.get(), preSpawnAction);
        horse.setInternalId(internalId);
        this.horseEntityCache.addEntityForHorse(horse);
        return horse;
    }

    private void removeHorseFromAllLevels(int internalId, HorseEntityType entityType) {
        for (ServerLevel level : ServerLevelUtil.getServerLevels()) {
            Optional<EntityHorse> horseEntity = this.findEntityForHorse(internalId, entityType, level);
            horseEntity.ifPresent(this::despawnHorse);
        }
        this.horseEntityCache.removeLocationDataForHorse(internalId);
    }

    @Override
    public void despawnHorse(int internalId, HorseEntityType entityType) {
        Optional<EntityHorse> entityHorse = this.findEntityForHorse(internalId, entityType);
        entityHorse.ifPresent(this::despawnHorse);
    }

    private void despawnHorse(EntityHorse entityHorse) {
        entityHorse.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public EntityHorse findHorseByUuid(ServerLevel serverLevel, UUID uuid) {
        for (Entity entity : serverLevel.m_8583_()) {
            EntityHorse entityHorse;
            if (!(entity instanceof EntityHorse) || !(entityHorse = (EntityHorse)entity).m_142081_().equals(uuid)) continue;
            return entityHorse;
        }
        return null;
    }

    @Override
    public void despawnAllHorses() {
        for (ServerLevel level : ServerLevelUtil.getServerLevels()) {
            for (EntityHorse entity : level.m_143280_(EntityTypeTest.m_156916_(EntityHorse.class), PredicateUtils.truePredicate())) {
                this.despawnHorse(entity);
            }
        }
    }

    private static /* synthetic */ Boolean lambda$spawnHorse$1(ServerLevel serverLevel, EntityHorse entity) {
        return serverLevel.m_7967_((Entity)entity);
    }

    private static /* synthetic */ EntityHorse lambda$spawnHorse$0(ServerLevel serverLevel, Consumer preSpawnAction, HorseSpawnData horseSpawnData, BlockPos blockPos, DirectionalCoordinate directionalCoordinate, HorseEntityType entityType, int internalId) {
        EntityHorse e = (EntityHorse)((EntityType)EntityInit.HORSE_ENTITY.get()).m_20615_((Level)serverLevel);
        if (e == null) {
            throw new IllegalArgumentException("Unable to create horse entity");
        }
        if (preSpawnAction != null) {
            preSpawnAction.accept(e);
        }
        if (horseSpawnData.textureDetails().hasTextureOverride()) {
            e.setTextureBase64(horseSpawnData.textureDetails().textureOverride());
        } else {
            e.setColorName(horseSpawnData.textureDetails().colorName().toLowerCase());
            if (horseSpawnData.textureDetails().markings().isEmpty()) {
                e.setPatternNames("none");
            } else {
                e.setPatternNames(String.join((CharSequence)",", horseSpawnData.textureDetails().markings()));
            }
            e.setGrayName(horseSpawnData.textureDetails().grayName().toLowerCase());
        }
        e.setGaitVariant(horseSpawnData.gaitVariant());
        e.m_6034_(blockPos.m_7494_().m_123341_(), blockPos.m_7494_().m_123342_(), blockPos.m_7494_().m_123343_());
        e.m_146926_(directionalCoordinate.rotationX());
        e.m_146922_(directionalCoordinate.rotationY());
        e.setHorseEntityType(entityType);
        e.setGait(horseSpawnData.gait());
        e.setBlocksPerSecondSpeed(horseSpawnData.baseSpeed());
        e.setInternalId(internalId);
        e.setMaxHorseJump(horseSpawnData.maximumJump());
        e.setHardGroundTraction(horseSpawnData.groundTractionPercentage().hard());
        e.setSoftGroundTraction(horseSpawnData.groundTractionPercentage().soft());
        e.setLooseGroundTraction(horseSpawnData.groundTractionPercentage().loose());
        return e;
    }
}

