/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.entity;

import com.equestricraft.common.util.DateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.StampedLock;

public class HorseTeleportTimeCache {
    private static final HorseTeleportTimeCache instance = new HorseTeleportTimeCache();
    private final List<PlayerHorseTeleport> playerHorseTeleports = new ArrayList<PlayerHorseTeleport>();
    private final StampedLock lock = new StampedLock();

    public static HorseTeleportTimeCache getInstance() {
        return instance;
    }

    private HorseTeleportTimeCache() {
        this.startClearTask();
    }

    private void startClearTask() {
        Timer timer = new Timer();
        long delay = 60000L;
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                HorseTeleportTimeCache.this.removeOldEntries();
            }
        }, delay, delay);
    }

    private void removeOldEntries() {
        long stamp = this.lock.writeLock();
        try {
            this.playerHorseTeleports.removeIf(t -> DateUtils.secondsSince(t.getTimeStamp()) > 60);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logPlayerTeleportHorse(int playerId, int horseId) {
        long stamp = this.lock.writeLock();
        try {
            Optional<PlayerHorseTeleport> existing = this.findTeleportByPlayerAndHorse(playerId, horseId);
            if (existing.isPresent()) {
                existing.get().setTimeStamp(System.currentTimeMillis());
            } else {
                PlayerHorseTeleport newTeleport = new PlayerHorseTeleport(playerId, horseId, System.currentTimeMillis());
                this.playerHorseTeleports.add(newTeleport);
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Long> getTimePlayerLastTeleportedHorse(int playerId, int horseId) {
        long stamp = this.lock.readLock();
        try {
            Optional<Long> optional = this.findTeleportByPlayerAndHorse(playerId, horseId).map(PlayerHorseTeleport::getTimeStamp);
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    private Optional<PlayerHorseTeleport> findTeleportByPlayerAndHorse(int playerId, int horseId) {
        return this.playerHorseTeleports.stream().filter(t -> t.getPlayerId() == playerId && t.getHorseId() == horseId).findFirst();
    }

    private static final class PlayerHorseTeleport {
        private final int playerId;
        private final int horseId;
        private long timeStamp;

        private PlayerHorseTeleport(int playerId, int horseId, long timeStamp) {
            this.playerId = playerId;
            this.horseId = horseId;
            this.timeStamp = timeStamp;
        }

        public int getPlayerId() {
            return this.playerId;
        }

        public int getHorseId() {
            return this.horseId;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerHorseTeleport that = (PlayerHorseTeleport)o;
            return this.playerId == that.playerId && this.horseId == that.horseId;
        }

        public int hashCode() {
            return Objects.hash(this.playerId, this.horseId);
        }
    }
}

