/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.entity;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.util.HorseHeightUtil;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Walk;
import com.equestricraft.core.horse.hoof.GroundType;
import com.equestricraft.core.horse.texture.HorseTextureDetails;
import com.equestricraft.core.horse.texture.HorseTextureSession;
import com.equestricraft.core.player.tack.HorseTackInfo;
import com.equestricraft.core.tack.bonnet.HorseBonnet;
import com.equestricraft.core.tack.boots.HorseBoots;
import com.equestricraft.core.tack.bridle.HorseBridle;
import com.equestricraft.core.tack.cinch.HorseCinch;
import com.equestricraft.core.tack.girth.HorseGirth;
import com.equestricraft.core.tack.halter.HorseHalter;
import com.equestricraft.core.tack.pad.HorsePad;
import com.equestricraft.core.tack.rein.HorseRein;
import com.equestricraft.core.tack.saddle.HorseSaddle;
import com.equestricraft.core.tack.wraps.HorseWraps;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.horse.cache.HorseEntityCache;
import com.equestricraft.mod.horse.entity.GroundTractionPercentage;
import com.equestricraft.mod.horse.entity.HorseEntitySession;
import com.equestricraft.mod.horse.entity.HorseSpawnData;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.BlockPosUtil;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityTypeTest;

public class StandardHorseEntitySessionImpl
implements StandardHorseEntitySession {
    @Service
    private HorseEntitySession horseEntitySession;
    @Service
    private HorseTextureSession horseTextureSession;
    private final HorseEntityCache horseEntityCache = HorseEntityCache.getInstance();

    @Override
    public void spawnHorse(EQHorse horse) {
        EntityHorse entity = this.horseEntitySession.spawnHorse(horse.getId(), HorseEntityType.STANDARD, horse.getDirectionalCoordinate(), this.createHorseSpawnData(horse), e -> this.setupData((EntityHorse)e, horse));
        this.initEntity(horse, entity);
    }

    private void setupData(EntityHorse entityHorse, EQHorse horse) {
        entityHorse.setHorseData(horse);
        entityHorse.setOwnerId(horse.getOwner().getId());
    }

    @Override
    public void spawnHorse(EQHorse horse, Entity targetEntityLocation) {
        EntityHorse entity = this.horseEntitySession.spawnHorse(horse.getId(), HorseEntityType.STANDARD, targetEntityLocation, this.createHorseSpawnData(horse), e -> this.setupData((EntityHorse)e, horse));
        this.initEntity(horse, entity);
    }

    private void initEntity(EQHorse horse, EntityHorse entity) {
        this.syncHorseDataToEntity(entity, horse);
        this.horseEntityCache.addEntityForHorse(entity);
    }

    @Override
    public void teleportHorse(EQHorse horse, OnlinePlayer player) {
        this.teleportHorse(horse, (Entity)player.serverPlayer());
    }

    @Override
    public void teleportHorse(EQHorse horse, Entity targetEntity) {
        EntityHorse entity = this.horseEntitySession.teleportHorse(horse.getId(), HorseEntityType.STANDARD, targetEntity, () -> this.createHorseSpawnData(horse), e -> this.setupData((EntityHorse)e, horse));
        this.syncHorseDataToEntity(entity, horse);
    }

    @Override
    public void teleportHorse(EQHorse horse, DirectionalCoordinate coordinate) {
        EntityHorse entity = this.horseEntitySession.teleportHorse(horse.getId(), HorseEntityType.STANDARD, coordinate, () -> this.createHorseSpawnData(horse), e -> this.setupData((EntityHorse)e, horse));
        this.syncHorseDataToEntity(entity, horse);
    }

    private void syncHorseDataToEntity(EntityHorse entity, EQHorse horse) {
        entity.setHorseData(horse);
        entity.setOwnerId(horse.getOwner().getId());
        entity.setGender(horse.getHorseGender());
        entity.setBonnetModel(horse.getTacks().getBonnet().map(HorseTackInfo::tack).map(HorseBonnet::getModel).orElse(null));
        entity.setBootsModel(horse.getTacks().getBoots().map(HorseTackInfo::tack).map(HorseBoots::getModel).orElse(null));
        entity.setBridleModel(horse.getTacks().getBridle().map(HorseTackInfo::tack).map(HorseBridle::getModel).orElse(null));
        entity.setCinchModel(horse.getTacks().getCinch().map(HorseTackInfo::tack).map(HorseCinch::getModel).orElse(null));
        entity.setGirthModel(horse.getTacks().getGirth().map(HorseTackInfo::tack).map(HorseGirth::getModel).orElse(null));
        entity.setHalterModel(horse.getTacks().getHalter().map(HorseTackInfo::tack).map(HorseHalter::getModel).orElse(null));
        entity.setPadModel(horse.getTacks().getPad().map(HorseTackInfo::tack).map(HorsePad::getModel).orElse(null));
        entity.setReinModel(horse.getTacks().getRein().map(HorseTackInfo::tack).map(HorseRein::getModel).orElse(null));
        entity.setSaddleModel(horse.getTacks().getSaddle().map(HorseTackInfo::tack).map(HorseSaddle::getModel).orElse(null));
        entity.setWrapsModel(horse.getTacks().getWraps().map(HorseTackInfo::tack).map(HorseWraps::getModel).orElse(null));
        entity.setAgeMonthsAtSpawn(horse.getAge().getMonths());
        double height = horse.getHeight().getMeters();
        float scale = HorseHeightUtil.metersToScale(height);
        entity.setModelScaleAtSpawn(scale);
        this.horseEntityCache.addEntityForHorse(entity);
    }

    private HorseSpawnData createHorseSpawnData(EQHorse horse) {
        HorseTextureDetails textureDetails = this.horseTextureSession.calculateTextureNameForHorse(horse);
        float jump = horse.getJump().getValue();
        float speed = horse.getSpeed().getValue(Walk.WORKING);
        GroundTractionPercentage traction = this.buildHorsesTraction(horse);
        return new HorseSpawnData(textureDetails, jump, speed, Walk.WORKING, horse.getGaitVariant(), traction);
    }

    private GroundTractionPercentage buildHorsesTraction(EQHorse horse) {
        return new GroundTractionPercentage(horse.getHooves().getTractionValue(GroundType.HARD), horse.getHooves().getTractionValue(GroundType.SOFT), horse.getHooves().getTractionValue(GroundType.LOOSE));
    }

    @Override
    public Optional<EntityHorse> findEntityForHorse(EQHorse horse) {
        return this.horseEntitySession.findEntityForHorse(horse.getId(), HorseEntityType.STANDARD);
    }

    @Override
    public Optional<EntityHorse> findEntityForHorse(EQHorse horse, ServerLevel level) {
        return this.horseEntitySession.findEntityForHorse(horse.getId(), HorseEntityType.STANDARD, level);
    }

    @Override
    public Boolean isHorseIndoors(EQHorse horse, ServerLevel serverLevel) {
        return this.findEntityForHorse(horse, serverLevel).map(e -> this.isHorseEntityIndoors((EntityHorse)e, serverLevel)).orElseGet(() -> this.isHorseLastKnownLocationIndoors(horse, serverLevel));
    }

    private Boolean isHorseEntityIndoors(EntityHorse entity, ServerLevel serverLevel) {
        return this.isPositionUndercover(entity.m_20097_(), serverLevel);
    }

    private Boolean isHorseLastKnownLocationIndoors(EQHorse horse, ServerLevel serverLevel) {
        DirectionalCoordinate lastKnownLocation = horse.getDirectionalCoordinate();
        if (lastKnownLocation == null) {
            return null;
        }
        BlockPos blockPos = BlockPosUtil.toBlockPos(lastKnownLocation);
        return this.isPositionUndercover(blockPos, serverLevel);
    }

    private Boolean isPositionUndercover(BlockPos blockPos, ServerLevel serverLevel) {
        while (blockPos.m_123342_() < 319) {
            Block block = serverLevel.m_8055_(blockPos = blockPos.m_7494_()).m_60734_();
            if (block == Blocks.f_50016_) continue;
            return true;
        }
        return false;
    }

    @Override
    public void despawnHorse(EQHorse horse) {
        this.horseEntitySession.despawnHorse(horse.getId(), HorseEntityType.STANDARD);
    }

    @Override
    public void dismountAllPassengers() {
        ArrayList entities = new ArrayList();
        for (ServerLevel level : ServerLevelUtil.getServerLevels()) {
            List horsesToRemove = level.m_143280_(EntityTypeTest.m_156916_(EntityHorse.class), horse -> !horse.m_20197_().isEmpty());
            entities.addAll(horsesToRemove);
        }
        entities.forEach(Entity::m_20153_);
    }
}

