/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.feeding;

import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.mod.client.bucket.EntityBucket;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.provision.ProvisionContainer;
import com.equestricraft.mod.provision.ProvisionContainerContentType;
import com.equestricraft.mod.util.BlockPosUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;

public class HorseKnownProvisionContainers {
    private final int horseId;
    private final List<EntityHorse> entityHorses = new ArrayList<EntityHorse>(0);
    private final StampedLock horsesLock = new StampedLock();
    private final LimitedContainerMemory containerMemory = new LimitedContainerMemory();
    private final StampedLock containersLock = new StampedLock();

    public HorseKnownProvisionContainers(int horseId) {
        this.horseId = horseId;
        this.startContainerSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHorseEntity(EntityHorse entityHorse) {
        long stamp = this.horsesLock.writeLock();
        try {
            this.entityHorses.add(entityHorse);
        }
        finally {
            this.horsesLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHorseEntity(EntityHorse entityHorse) {
        long stamp = this.horsesLock.writeLock();
        try {
            this.entityHorses.remove(entityHorse);
        }
        finally {
            this.horsesLock.unlockWrite(stamp);
        }
    }

    private void startContainerSearch() {
        Timer timer = new Timer(ThreadUtils.threadName("provision-search-" + this.horseId));
        TimerTask containerSearchTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    for (EntityHorse entityHorse : HorseKnownProvisionContainers.this.entityHorses) {
                        HorseKnownProvisionContainers.this.searchContainers(entityHorse);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        long duration = Duration.ofSeconds(30L).toMillis();
        timer.schedule(containerSearchTask, duration, duration);
    }

    private void searchContainers(EntityHorse entityHorse) {
        ServerLevel serverLevel = (ServerLevel)entityHorse.f_19853_;
        double searchRadius = this.getSearchRadius(entityHorse);
        for (EntityBucket bucketEntity : serverLevel.m_143280_(EntityTypeTest.m_156916_(EntityBucket.class), e -> e.getPosition().m_82554_(entityHorse.m_20182_()) <= searchRadius)) {
            this.addContainerPosition(BlockPosUtil.toBlockCoordinate(bucketEntity.m_20097_(), (Level)serverLevel), bucketEntity);
        }
    }

    private double getSearchRadius(EntityHorse horse) {
        Double defaultSearchRadius = HorseSettings.getProvisionContainerSearchRadius();
        double changeBasedOnIntelligence = defaultSearchRadius / 2.0 * (double)horse.getHorseData().getIntelligence().getValue();
        return defaultSearchRadius / 2.0 + changeBasedOnIntelligence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContainerPosition(BlockCoordinate coordinate, ProvisionContainer<? extends Entity> container) {
        long stamp = this.containersLock.writeLock();
        try {
            if (this.containerMemory.stream().anyMatch(c -> c.coordinate().equals(coordinate))) {
                return;
            }
            this.containerMemory.add(new ContainerPosition(coordinate, container));
        }
        finally {
            this.containersLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProvisionContainer<? extends Entity>> findNearbyNonEmptyContainers(EntityHorse entityHorse, BlockCoordinate blockCoordinate, List<ProvisionContainerContentType> priorities) {
        if (entityHorse.getInternalId() != this.horseId) {
            return Collections.emptyList();
        }
        if (this.containerMemory.isEmpty()) {
            this.searchContainers(entityHorse);
        }
        long stamp = this.containersLock.readLock();
        try {
            List<ProvisionContainer> nearby = this.containerMemory.stream().filter(Predicate.not(c -> c.container().isEmpty())).filter(c -> priorities.contains((Object)c.container().getContentType())).sorted(this.compareByDesiredPriority(priorities).thenComparing(c -> c.coordinate().distanceTo(blockCoordinate))).map(ContainerPosition::container).toList();
            ArrayList<ProvisionContainer<? extends Entity>> arrayList = new ArrayList<ProvisionContainer<? extends Entity>>(nearby);
            return arrayList;
        }
        finally {
            this.containersLock.unlockRead(stamp);
        }
    }

    private Comparator<ContainerPosition> compareByDesiredPriority(List<ProvisionContainerContentType> priorities) {
        return (c1, c2) -> {
            if (c1.container().getContentType() == c2.container().getContentType()) {
                return 0;
            }
            if (priorities.indexOf((Object)c1.container().getContentType()) < priorities.indexOf((Object)c2.container().getContentType())) {
                return 1;
            }
            return -1;
        };
    }

    private class LimitedContainerMemory
    extends LinkedList<ContainerPosition> {
        private LimitedContainerMemory() {
        }

        @Override
        public boolean add(ContainerPosition containerPosition) {
            if (this.size() >= this.getHorsesMemoryLimit()) {
                this.removeFirst();
            }
            return super.add(containerPosition);
        }

        private int getHorsesMemoryLimit() {
            return HorseKnownProvisionContainers.this.entityHorses.stream().map(EntityHorse::getHorseData).filter(Objects::nonNull).findFirst().map(h -> (int)h.getMemory().getPercentage()).orElse(100);
        }
    }

    private record ContainerPosition(BlockCoordinate coordinate, ProvisionContainer<? extends Entity> container) {
    }
}

