/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.feeding;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.gait.Canter;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.gait.Walk;
import com.equestricraft.core.horse.provision.ProvisionContainerInfo;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.horse.feeding.HorseConsumeFromContainerEvent;
import com.equestricraft.mod.horse.feeding.HorseKnownProvisionContainerManager;
import com.equestricraft.mod.horse.feeding.HorseKnownProvisionContainers;
import com.equestricraft.mod.provision.ProvisionContainer;
import com.equestricraft.mod.provision.ProvisionContainerContentType;
import com.equestricraft.mod.util.BlockPosUtil;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class HorseProvisionContainerConsumeGoal
extends AbstractHorseGoal {
    private static final int PROVISION_CHECK_SECONDS_INTERVAL = 20;
    private static final int CONSUME_DURATION_SECONDS = 3;
    private EQHorse horse = null;
    private HorseKnownProvisionContainers knownProvisionContainers = null;
    private long lastProvisionCheckTime = 0L;
    private int foodSearchPriority = 0;
    private int drinkSearchPriority = 0;
    private ContainerTarget containerTarget = null;
    private final ProvisionGoalPhase searchingPhase = new SearchingPhase();
    private final ProvisionGoalPhase travellingToPhase = new TravellingToPhase();
    private final ProvisionGoalPhase consumingPhase = new ConsumingPhase();
    private ProvisionGoalPhase activePhase = null;
    private final HorseKnownProvisionContainerManager horseKnownProvisionContainerManager = HorseKnownProvisionContainerManager.getInstance();

    public HorseProvisionContainerConsumeGoal(EntityHorse horse) {
        super(horse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    @Override
    public boolean shouldRun() {
        return FeatureFlag.FEED_CONTAINER.isEnabled() && this.isValidLevel() && !this.entityHorse.m_20160_() && this.shouldProcess();
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.activePhase != null && !this.entityHorse.m_20160_();
    }

    private boolean isValidLevel() {
        ECLevel level = ServerLevelUtil.getEntitiesECLevel((Entity)this.entityHorse);
        return level == ECLevel.PLOT_GRID || level == ECLevel.PLOT_NATURAL;
    }

    private boolean shouldProcess() {
        if (this.activePhase != null) {
            return true;
        }
        if (DateUtils.secondsSince(this.lastProvisionCheckTime) < 20) {
            return false;
        }
        this.horse = this.entityHorse.getHorseData();
        this.updateSearchPriorities();
        this.lastProvisionCheckTime = System.currentTimeMillis();
        return this.foodSearchPriority > 0 || this.drinkSearchPriority > 0;
    }

    private void updateSearchPriorities() {
        float fullness = this.horse.getProvision().getFullness();
        float hydration = this.horse.getProvision().getHydration();
        if (this.shouldSearchBasedOnValue(fullness)) {
            this.foodSearchPriority = 1;
        }
        if (this.shouldSearchBasedOnValue(hydration)) {
            this.drinkSearchPriority = 1;
        }
        if (fullness < hydration) {
            this.foodSearchPriority = this.foodSearchPriority == 1 ? 2 : 0;
        } else if (hydration < fullness) {
            this.drinkSearchPriority = this.drinkSearchPriority == 1 ? 2 : 0;
        }
    }

    private boolean shouldSearchBasedOnValue(float value) {
        if (value > 0.7f) {
            return false;
        }
        return value >= this.entityHorse.m_21187_().nextFloat();
    }

    @Override
    public void startGoal() {
        this.entityHorse.m_21573_().m_26573_();
        this.changePhase(this.searchingPhase);
        this.horse = this.entityHorse.getHorseData();
        this.knownProvisionContainers = this.horseKnownProvisionContainerManager.getKnownContainersForHorse(this.entityHorse.getInternalId());
    }

    @Override
    public void tickGoal() {
        this.activePhase.tick();
    }

    @Override
    public void stopGoal() {
        this.entityHorse.m_21573_().m_26573_();
        this.entityHorse.setGait(Halt.DEFAULT);
    }

    private void changePhase(ProvisionGoalPhase nextPhase) {
        if (Objects.equals(this.activePhase, nextPhase)) {
            return;
        }
        if (this.activePhase != null) {
            this.activePhase.onStop();
        }
        if (nextPhase != null) {
            nextPhase.onStart();
        }
        this.activePhase = nextPhase;
    }

    private record ContainerTarget(ProvisionContainer<? extends Entity> container, Path pathToContainer) {
        boolean canReach() {
            return this.pathToContainer != null && this.pathToContainer.m_77403_();
        }
    }

    private class SearchingPhase
    implements ProvisionGoalPhase {
        private int failedSearchAttempts = 0;

        private SearchingPhase() {
        }

        @Override
        public void onStart() {
            HorseProvisionContainerConsumeGoal.this.updateSearchPriorities();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tick() {
            try {
                HorseProvisionContainerConsumeGoal.this.updateSearchPriorities();
                BlockCoordinate coordinateOfHorse = BlockPosUtil.toBlockCoordinate(HorseProvisionContainerConsumeGoal.this.entityHorse.m_142538_(), HorseProvisionContainerConsumeGoal.this.entityHorse.m_183503_());
                List<ProvisionContainer<? extends Entity>> containers = HorseProvisionContainerConsumeGoal.this.knownProvisionContainers.findNearbyNonEmptyContainers(HorseProvisionContainerConsumeGoal.this.entityHorse, coordinateOfHorse, this.buildPriorityList());
                Optional<ContainerTarget> targets = containers.stream().map(this::buildTarget).filter(ContainerTarget::canReach).findFirst();
                if (targets.isPresent()) {
                    HorseProvisionContainerConsumeGoal.this.containerTarget = targets.get();
                    HorseProvisionContainerConsumeGoal.this.changePhase(HorseProvisionContainerConsumeGoal.this.travellingToPhase);
                } else {
                    ++this.failedSearchAttempts;
                }
            }
            finally {
                if (this.failedSearchAttempts == HorseSettings.getFailedProvisionFindAttemptNotification()) {
                    TaskScheduler.executeAsyncTask(() -> HorseProvisionContainerConsumeGoal.this.horse.getOwner().notify(I18n.getLabel("horse.provision.couldnt-find-provision.notification", HorseProvisionContainerConsumeGoal.this.horse.getName())));
                    HorseProvisionContainerConsumeGoal.this.horse.getFrustration().increment(this.determineFrustrationIncrease());
                }
            }
        }

        private float determineFrustrationIncrease() {
            return 1.0f - HorseProvisionContainerConsumeGoal.this.horse.getProvision().getFullness();
        }

        @Override
        public void onStop() {
            this.failedSearchAttempts = 0;
        }

        private List<ProvisionContainerContentType> buildPriorityList() {
            ArrayList<ProvisionContainerContentType> list = new ArrayList<ProvisionContainerContentType>();
            if (HorseProvisionContainerConsumeGoal.this.drinkSearchPriority > HorseProvisionContainerConsumeGoal.this.foodSearchPriority) {
                list.add(ProvisionContainerContentType.WATER);
                if (HorseProvisionContainerConsumeGoal.this.foodSearchPriority > 0) {
                    list.add(ProvisionContainerContentType.FEED);
                }
            } else if (HorseProvisionContainerConsumeGoal.this.foodSearchPriority > HorseProvisionContainerConsumeGoal.this.drinkSearchPriority) {
                list.add(ProvisionContainerContentType.FEED);
                if (HorseProvisionContainerConsumeGoal.this.drinkSearchPriority > 0) {
                    list.add(ProvisionContainerContentType.WATER);
                }
            } else {
                list.add(ProvisionContainerContentType.FEED);
                list.add(ProvisionContainerContentType.WATER);
            }
            return list;
        }

        private ContainerTarget buildTarget(ProvisionContainer<? extends Entity> c) {
            Path path = HorseProvisionContainerConsumeGoal.this.entityHorse.m_21573_().m_6570_(c.asEntity(), 1);
            return new ContainerTarget(c, path);
        }
    }

    private static interface ProvisionGoalPhase {
        default public void onStart() {
        }

        public void tick();

        default public void onStop() {
        }
    }

    private class TravellingToPhase
    implements ProvisionGoalPhase {
        private TravellingToPhase() {
        }

        @Override
        public void onStart() {
            this.navigateToContainer();
        }

        @Override
        public void tick() {
            if (HorseProvisionContainerConsumeGoal.this.containerTarget.container().isEmpty()) {
                HorseProvisionContainerConsumeGoal.this.containerTarget = null;
                HorseProvisionContainerConsumeGoal.this.changePhase(HorseProvisionContainerConsumeGoal.this.searchingPhase);
                return;
            }
            if (HorseProvisionContainerConsumeGoal.this.entityHorse.m_21573_().m_26571_()) {
                HorseProvisionContainerConsumeGoal.this.entityHorse.m_21573_().m_26573_();
                HorseProvisionContainerConsumeGoal.this.changePhase(HorseProvisionContainerConsumeGoal.this.consumingPhase);
            } else if (HorseProvisionContainerConsumeGoal.this.entityHorse.m_21573_().m_26577_()) {
                HorseProvisionContainerConsumeGoal.this.entityHorse.m_21573_().m_26573_();
                HorseProvisionContainerConsumeGoal.this.changePhase(HorseProvisionContainerConsumeGoal.this.searchingPhase);
            } else {
                Path path = HorseProvisionContainerConsumeGoal.this.entityHorse.m_21573_().m_26570_();
                if (path != null) {
                    float distance = path.m_77407_();
                    if (distance > 20.0f) {
                        HorseProvisionContainerConsumeGoal.this.entityHorse.setGait(Canter.WORKING);
                    } else {
                        HorseProvisionContainerConsumeGoal.this.entityHorse.setGait(Canter.EXTENDED);
                    }
                }
            }
        }

        private void navigateToContainer() {
            HorseSubGait gait = HorseProvisionContainerConsumeGoal.this.entityHorse.getHorseData().getGait().getHighestAvailable();
            HorseProvisionContainerConsumeGoal.this.entityHorse.setGait(gait);
            HorseProvisionContainerConsumeGoal.this.entityHorse.m_21573_().m_26536_(HorseProvisionContainerConsumeGoal.this.containerTarget.pathToContainer(), HorseSettings.getProvisionContainerConsumeDistance().doubleValue());
        }
    }

    private class ConsumingPhase
    implements ProvisionGoalPhase {
        private long consumingStartTime = 0L;

        private ConsumingPhase() {
        }

        @Override
        public void onStart() {
            this.consumingStartTime = System.currentTimeMillis();
            HorseProvisionContainerConsumeGoal.this.entityHorse.setConsumingFromProvisionContainer(true);
            HorseProvisionContainerConsumeGoal.this.entityHorse.setGait(Halt.DEFAULT);
        }

        @Override
        public void tick() {
            if (DateUtils.secondsSince(this.consumingStartTime) > 3) {
                HorseProvisionContainerConsumeGoal.this.changePhase(null);
                ContainerTarget container = HorseProvisionContainerConsumeGoal.this.containerTarget;
                TaskScheduler.executeAsyncTask(() -> this.processConsumeFinished(container.container()));
            }
        }

        private void processConsumeFinished(ProvisionContainer<? extends Entity> container) {
            ProvisionContainerInfo info2 = container.getProvisionInfo();
            HorseConsumeFromContainerEvent event = new HorseConsumeFromContainerEvent(HorseProvisionContainerConsumeGoal.this.entityHorse, info2, 0.2f);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            if (!cancelled) {
                container.setQuantity(container.getQuantity() - 0.2f);
            }
        }

        @Override
        public void onStop() {
            HorseProvisionContainerConsumeGoal.this.entityHorse.setConsumingFromProvisionContainer(false);
            HorseProvisionContainerConsumeGoal.this.entityHorse.setGait(Walk.WORKING);
        }
    }
}

