/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.feeding;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.provision.ProvisionContainerInfo;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.EntityInit;
import com.equestricraft.mod.client.bucket.EntityBucket;
import com.equestricraft.mod.client.item.ModItems;
import com.equestricraft.mod.horse.feeding.HorseConsumeFromContainerEvent;
import com.equestricraft.mod.horse.feeding.HorseProvisionContainerService;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.provision.ProvisionContainer;
import com.equestricraft.mod.provision.ProvisionContainerInteractEvent;
import com.equestricraft.mod.provision.ProvisionService;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class HorseProvisionContainerListener {
    @Service
    private static HorseProvisionContainerService horseProvisionContainerService;
    @Service
    private static ProvisionService provisionService;
    private static final OnlinePlayerCache onlinePlayerCache;
    private static final Log log;

    @SubscribeEvent
    public static void onFeed(HorseConsumeFromContainerEvent event) {
        boolean consumed = horseProvisionContainerService.consumeContainerContents(event.getHorse(), event.getProvision(), event.getUnitsToConsume());
        if (!consumed) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFeedPlace(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (FeatureFlag.FEED_CONTAINER.isDisabled()) {
            return;
        }
        OnlinePlayer player = onlinePlayerCache.requirePlayer(event.getPlayer().m_142081_()).require(OnlinePlayer.class);
        ItemStack itemStack = event.getPlayer().m_6844_(EquipmentSlot.MAINHAND);
        Item item = itemStack.m_41720_();
        if (!((Object)((Object)ModItems.getProvisionBucket())).equals(item)) {
            return;
        }
        EntityBucket entity = (EntityBucket)((EntityType)EntityInit.BUCKET_ENTITY.get()).m_20615_(event.getWorld());
        if (entity != null) {
            BlockPos pos = event.getPos().m_142300_(event.getHitVec().m_82434_());
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            boolean added = event.getWorld().m_7967_((Entity)entity);
            if (!added) {
                log.warn("Bucket entity could not be added");
            }
            provisionService.showProvisionItemsMenuToPlayer(player, entity);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFeedingBucketInteract(ProvisionContainerInteractEvent event) {
        if (FeatureFlag.FEED_CONTAINER.isDisabled()) {
            return;
        }
        ProvisionContainer container = event.getContainer();
        OnlinePlayer player = onlinePlayerCache.requirePlayer(event.getPlayer().m_142081_()).require(OnlinePlayer.class);
        if (container.getProvisionInfo() != null) {
            horseProvisionContainerService.showContainersContents(player, container);
        } else {
            provisionService.showProvisionItemsMenuToPlayer(player, container);
        }
    }

    @SubscribeEvent
    public static void onFeedBucketLeftClick(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof EntityBucket) {
            EntityBucket entityBucket = (EntityBucket)entity;
            if (event.getPlayer() instanceof ServerPlayer) {
                if (FeatureFlag.FEED_CONTAINER.isDisabled()) {
                    return;
                }
                OnlinePlayer player = onlinePlayerCache.requirePlayer(event.getPlayer().m_142081_()).require(OnlinePlayer.class);
                if (entityBucket.getProvisionInfo() != null) {
                    ProvisionContainerInfo info2 = entityBucket.getProvisionInfo();
                    TaskScheduler.executeAsyncTask(() -> horseProvisionContainerService.returnProvisionsToInventory(player, info2));
                    entityBucket.setProvisionInfo(null);
                    entityBucket.setQuantity(0.0f);
                }
                entityBucket.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private HorseProvisionContainerListener() {
    }

    static {
        onlinePlayerCache = OnlinePlayerCache.getInstance();
        log = Log.getLogger(HorseProvisionContainerListener.class.getName());
    }
}

