/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.feeding;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.ProvisionType;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.provision.ProvisionContainerInfo;
import com.equestricraft.core.player.provision.ProvisionInventoryItem;
import com.equestricraft.core.player.provision.ProvisionInventoryItemRepository;
import com.equestricraft.core.player.provision.ProvisionInventoryItemSession;
import com.equestricraft.core.provision.Provision;
import com.equestricraft.core.provision.ProvisionRepository;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.feeding.HorseProvisionContainerService;
import com.equestricraft.mod.packet.ClientBoundProvisionBlockInfoOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.provision.ProvisionBlockInformation;
import com.equestricraft.mod.provision.ProvisionContainer;
import com.equestricraft.mod.provision.ProvisionContainerAmount;
import com.equestricraft.mod.provision.ProvisionContainerContentType;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class HorseProvisionContainerServiceImpl
implements HorseProvisionContainerService {
    @Service
    private ProvisionInventoryItemRepository provisionInventoryItemRepository;
    @Service
    private ProvisionRepository provisionRepository;
    @Service
    private ProvisionInventoryItemSession provisionInventoryItemSession;
    private static final Log log = Log.getLogger(HorseProvisionContainerServiceImpl.class.getName());

    @Override
    public boolean consumeContainerContents(EntityHorse horse, ProvisionContainerInfo provisionContainerInfo, double units) {
        EQHorse h = horse.getHorseData();
        if (h == null) {
            log.warn("A horse entity has no horse data");
            return false;
        }
        return h.getProvision().giveProvision(provisionContainerInfo, units);
    }

    @Override
    public void setContainersContents(Integer containerEntityId, ECLevel level, UUID provisionUuid) {
        ServerLevel serverLevel = ServerLevelUtil.getServerLevel(level.getIdentifier());
        Entity blockEntity = serverLevel.m_6815_(containerEntityId.intValue());
        if (blockEntity instanceof ProvisionContainer) {
            ProvisionContainer provisionContainer = (ProvisionContainer)blockEntity;
            TaskScheduler.executeAsyncTask(() -> {
                ProvisionInventoryItem inventoryItem = (ProvisionInventoryItem)this.provisionInventoryItemRepository.findByKey(provisionUuid);
                Provision provision = (Provision)this.provisionRepository.findByKey(inventoryItem.getProvisionId());
                if (!provision.isDivisible()) {
                    return;
                }
                ProvisionContainerInfo info2 = new ProvisionContainerInfo(inventoryItem.getProvisionId(), inventoryItem.getAcquireTime(), inventoryItem.isSpoiled());
                TaskScheduler.executeSyncTask(() -> {
                    provisionContainer.setProvisionInfo(info2);
                    provisionContainer.setQuantity(1.0f);
                    provisionContainer.setContentType(provision.getProvisionType() == ProvisionType.FOOD ? ProvisionContainerContentType.FEED : ProvisionContainerContentType.WATER);
                });
                this.provisionInventoryItemSession.removeItemFromInventory(provisionUuid, 1.0);
            });
        }
    }

    @Override
    public void showContainersContents(OnlinePlayer player, ProvisionContainer provisionContainer) {
        Provision provision = (Provision)this.provisionRepository.findByKey(provisionContainer.getProvisionInfo().provisionId());
        ProvisionBlockInformation info2 = new ProvisionBlockInformation(provision.getName(), this.getType(provisionContainer.getQuantity()));
        ClientBoundProvisionBlockInfoOpenPacket packet = new ClientBoundProvisionBlockInfoOpenPacket(info2);
        player.sendPacket(packet);
    }

    @Override
    public void returnProvisionsToInventory(OnlinePlayer player, ProvisionContainerInfo provisionInfo) {
        Provision provision = (Provision)this.provisionRepository.findByKey(provisionInfo.provisionId());
        this.provisionInventoryItemSession.addItemToInventory(player, provision, 1);
    }

    private ProvisionContainerAmount getType(float amount) {
        if (amount >= 1.0f) {
            return ProvisionContainerAmount.FULL;
        }
        if ((double)amount > 0.6) {
            return ProvisionContainerAmount.NEARLY_FULL;
        }
        if ((double)amount > 0.4) {
            return ProvisionContainerAmount.HALF;
        }
        if (amount > 0.0f) {
            return ProvisionContainerAmount.NEARLY_EMPTY;
        }
        return ProvisionContainerAmount.EMPTY;
    }
}

