/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.follow;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.follow.HorseFollowCommandEvent;
import com.equestricraft.core.horse.instruction.HorseInstruction;
import com.equestricraft.core.horse.instruction.HorseInstructionProvider;
import com.equestricraft.core.horse.instruction.HorseInstructionState;
import com.equestricraft.core.horse.instruction.HorseInstructionType;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.skill.Skill;
import com.equestricraft.mod.client.MobFollowPlayerGoal;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.horse.HorseFollowPlayerAction;
import com.equestricraft.mod.horse.entity.HorseEntitySession;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

public class HorseFollowInstruction
extends HorseInstruction {
    @Service
    private static HorseEntitySession horseEntitySession;
    private MobFollowPlayerGoal goal = null;

    private HorseFollowInstruction(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getInstructionLabel() {
        return switch (this.getState()) {
            default -> throw new IncompatibleClassChangeError();
            case HorseInstructionState.ACTIVE -> I18n.getLabel("horse.instruction.follow.stop.label");
            case HorseInstructionState.INACTIVE -> I18n.getLabel("horse.instruction.follow.start.label");
        };
    }

    @Override
    public HorseInstructionType getType() {
        return HorseInstructionType.FOLLOW;
    }

    @Override
    public Response canGive(ECPlayer player) {
        if (!player.getSkills().hasSkill(Skill.FOLLOW_PLAYER)) {
            return ResponseFactory.fail(I18n.getLabel("horse.follow.skill-not-learned.player"));
        }
        if (!this.horse.getSkill().hasSkill(Skill.FOLLOW_PLAYER)) {
            return ResponseFactory.fail(I18n.getLabel("horse.follow.skill-not-learned.horse"));
        }
        return ResponseFactory.success();
    }

    @Override
    protected void onStart(ECPlayer player) {
        ECEventBus.post(new HorseFollowCommandEvent(this.horse, player));
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        Optional<EntityHorse> entity = horseEntitySession.findEntityForHorse(this.horse.getId(), HorseEntityType.STANDARD, onlinePlayer.getServerLevel());
        if (entity.isPresent()) {
            HorseFollowPlayerAction action = new HorseFollowPlayerAction(this.horse, onlinePlayer, entity.get());
            this.horse.getActions().processAction(action);
        }
    }

    @Override
    protected void onStop(ECPlayer player) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        Optional<EntityHorse> entity = horseEntitySession.findEntityForHorse(this.horse.getId(), HorseEntityType.STANDARD, onlinePlayer.getServerLevel());
        entity.ifPresent(EntityHorse::stopFollowing);
    }

    @Override
    public HorseInstructionState getState() {
        return this.goal != null && this.goal.isActive() ? HorseInstructionState.ACTIVE : HorseInstructionState.INACTIVE;
    }

    public static class Provider
    implements HorseInstructionProvider {
        @Override
        public HorseInstructionType getType() {
            return HorseInstructionType.FOLLOW;
        }

        @Override
        public <T extends HorseInstruction> T getInstruction(EQHorse horse) {
            return (T)new HorseFollowInstruction(horse);
        }
    }
}

