/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.grouprun;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.gait.Canter;
import com.equestricraft.core.horse.restless.RestlessTrait;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.horse.grouprun.HorseRunInGroupGoal;
import com.equestricraft.mod.horse.grouprun.HorseRunningGroup;
import com.equestricraft.mod.horse.grouprun.HorseStartRunningInGroupAction;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HorseFindRunningGroupGoal
extends AbstractHorseGoal {
    private long lastFind = 0L;

    public HorseFindRunningGroupGoal(EntityHorse entityHorse) {
        super(entityHorse);
    }

    @Override
    public boolean shouldRun() {
        return FeatureFlag.RELATIONSHIPS.isEnabled() && !this.entityHorse.m_20160_() && this.hasEnoughTimePassed() && this.entityHorse.m_21187_().nextFloat() <= this.determineProbability();
    }

    private boolean hasEnoughTimePassed() {
        return DateUtils.secondsSince(this.lastFind) > 20;
    }

    private float determineProbability() {
        return this.entityHorse.getHorseData().getStamina().getValue() / 5.0f;
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.m_8036_();
    }

    @Override
    public void startGoal() {
        List nearbyHorses = this.entityHorse.f_19853_.m_45971_(EntityHorse.class, TargetingConditions.m_148353_(), (LivingEntity)this.entityHorse, new AABB(this.entityHorse.m_142538_()).m_82400_(10.0));
        Optional<EntityHorse> nearbyHorseWithGroup = nearbyHorses.stream().filter(h -> h.getRunInGroupGoal().getGroup() != null).findFirst();
        EQHorse horseData = this.entityHorse.getHorseData();
        this.lastFind = System.currentTimeMillis();
        if (nearbyHorseWithGroup.isPresent()) {
            HorseRunInGroupGoal otherHorsesGoal = nearbyHorseWithGroup.get().getRunInGroupGoal();
            HorseRunningGroup group = otherHorsesGoal.getGroup();
            if (this.isGroupPositionUnreachable(group)) {
                horseData.getFrustration().increment(this.determineFrustrationIncrementAmount());
                return;
            }
            TaskScheduler.executeAsyncTask(() -> horseData.getActions().processAction(new HorseStartRunningInGroupAction(horseData, this.entityHorse, otherHorsesGoal.getGroup())));
        } else if (!nearbyHorses.isEmpty()) {
            Vec3 position = this.getReachablePosition();
            if (position == null) {
                horseData.getFrustration().increment(this.determineFrustrationIncrementAmount());
                return;
            }
            HorseRunningGroup newGroup = new HorseRunningGroup(position, this.entityHorse.getHorseData().getGait().getHighestAvailable(Canter.WORKING));
            HorseRunInGroupGoal thisHorsesGoal = this.entityHorse.getRunInGroupGoal();
            thisHorsesGoal.setGroup(newGroup);
            TaskScheduler.executeAsyncTask(() -> nearbyHorses.stream().filter(h -> h.getRunInGroupGoal().getGroup() == null).filter(h -> horseData.getRelationships().offerInteraction(h.getHorseData())).forEach(h -> {
                EQHorse hData = h.getHorseData();
                hData.getActions().processAction(new HorseStartRunningInGroupAction(hData, (EntityHorse)h, newGroup));
            }));
        }
    }

    private float determineFrustrationIncrementAmount() {
        float value = this.entityHorse.getHorseData().getTraits().getValue(RestlessTrait.class) / 5.0f;
        return NumberUtils.keepWithinRange(Float.valueOf(value), Float.valueOf(0.0f), Float.valueOf(0.2f)).floatValue();
    }

    private boolean isGroupPositionUnreachable(HorseRunningGroup group) {
        Vec3 position = group.getTargetPosition();
        Path path = this.entityHorse.m_21573_().m_26524_(position.f_82479_, position.f_82480_, position.f_82481_, 1);
        return path == null || !path.m_77403_();
    }

    private Vec3 getReachablePosition() {
        for (int i = 0; i < this.determineSearchAttempts(); ++i) {
            Path path;
            Vec3 position = this.getRandomTargetPosition();
            if (position == null || (path = this.entityHorse.m_21573_().m_26524_(position.f_82479_, position.f_82480_, position.f_82481_, 1)) == null || !path.m_77403_()) continue;
            return position;
        }
        return null;
    }

    private int determineSearchAttempts() {
        return (int)(this.entityHorse.getHorseData().getIntelligence().getValue() * 10.0f);
    }

    private Vec3 getRandomTargetPosition() {
        int xzRange = HorseSettings.getMaximumRandomWanderDistance();
        int yRange = 7;
        return LandRandomPos.m_148488_((PathfinderMob)this.entityHorse, (int)xzRange, (int)yRange);
    }
}

