/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.grouprun;

import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.horse.grouprun.HorseRunningGroup;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class HorseRunInGroupGoal
extends AbstractHorseGoal {
    private HorseRunningGroup group = null;

    public HorseRunInGroupGoal(EntityHorse entityHorse) {
        super(entityHorse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public HorseRunningGroup getGroup() {
        return this.group;
    }

    public void setGroup(HorseRunningGroup group) {
        this.group = group;
        group.addHorse(this.entityHorse);
    }

    @Override
    public boolean shouldRun() {
        return FeatureFlag.RELATIONSHIPS.isEnabled() && this.group != null && !this.entityHorse.m_20160_();
    }

    @Override
    public void startGoal() {
        this.entityHorse.m_21573_().m_26573_();
        Vec3 pos = this.group.getTargetPosition();
        Path path = this.entityHorse.m_21573_().m_26524_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1);
        this.entityHorse.setGait(this.group.getGait());
        this.entityHorse.m_21573_().m_26536_(path, 3.0);
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.m_8036_() && this.group.getAveragePosition().m_82554_(this.entityHorse.m_20182_()) <= 10.0;
    }

    @Override
    public void tickGoal() {
        if (this.entityHorse.m_21573_().m_26571_()) {
            this.group.removeHorse(this.entityHorse);
            this.applyFriendship();
            this.group = null;
        }
    }

    private void applyFriendship() {
        for (EntityHorse horseInGroup : this.group.getHorses()) {
            if (horseInGroup.getHorseData().equals(this.entityHorse.getHorseData())) continue;
            this.entityHorse.getHorseData().getRelationships().createInteractionWithHorse(horseInGroup.getHorseData(), 5.0);
        }
    }

    @Override
    public void stopGoal() {
        if (this.group != null) {
            this.group.removeHorse(this.entityHorse);
            this.applyFriendship();
            this.entityHorse.getHorseData().getFrustration().decrement(0.2f);
            this.group = null;
            this.entityHorse.m_21573_().m_26573_();
            this.entityHorse.setGait(Halt.DEFAULT);
        }
    }
}

