/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.grouprun;

import com.equestricraft.common.CachedValue;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.mod.client.horse.EntityHorse;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class HorseRunningGroup {
    private final List<EntityHorse> horses = new ArrayList<EntityHorse>();
    private final Vec3 targetPosition;
    private final HorseSubGait gait;
    private final CachedValue<Vec3> averagePosition = new CachedValue<Vec3>(this::calculateAveragePosition, 5);

    public HorseRunningGroup(Vec3 targetPosition, HorseSubGait gait) {
        this.targetPosition = targetPosition;
        this.gait = gait;
    }

    protected void addHorse(EntityHorse horse) {
        this.horses.add(horse);
    }

    protected void removeHorse(EntityHorse horse) {
        this.horses.remove(horse);
    }

    protected List<EntityHorse> getHorses() {
        return this.horses;
    }

    protected Vec3 getTargetPosition() {
        return this.targetPosition;
    }

    protected HorseSubGait getGait() {
        return this.gait;
    }

    protected Vec3 getAveragePosition() {
        return this.averagePosition.get();
    }

    private Vec3 calculateAveragePosition() {
        List<Vec3> positions = this.horses.stream().map(Entity::m_20182_).toList();
        double xValue = positions.stream().mapToDouble(Vec3::m_7096_).average().orElse(0.0);
        double yValue = positions.stream().mapToDouble(Vec3::m_7098_).average().orElse(0.0);
        double zValue = positions.stream().mapToDouble(Vec3::m_7094_).average().orElse(0.0);
        return new Vec3(xValue, yValue, zValue);
    }
}

