/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.idleaction;

import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.horse.HorseSettings;
import java.util.List;

public enum HorseIdleAction {
    RESTING(List.of("RESTING_1")),
    GRAZING(List.of("GRAZING_1")),
    PAWING(List.of("PAWING_1"));

    private final List<String> animations;

    private HorseIdleAction(List<String> animations) {
        this.animations = animations;
    }

    public String getRandomAnimation() {
        return ListUtils.getRandomItem(this.animations);
    }

    public Integer getDurationSeconds() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case RESTING -> HorseSettings.getRestingAnimationDurationSeconds();
            case GRAZING -> HorseSettings.getGrazingAnimationDurationSeconds();
            case PAWING -> HorseSettings.getPawingAnimationDurationSeconds();
        };
    }

    public static HorseIdleAction getRandom() {
        return ListUtils.getRandom(HorseIdleAction.values());
    }
}

