/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.idleaction;

import com.equestricraft.common.util.ListUtils;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.horse.idleaction.HorseIdleAction;

public class HorseIdleActionGoal
extends AbstractHorseGoal {
    private long currentActionEndTime = 0L;

    public HorseIdleActionGoal(EntityHorse entityHorse) {
        super(entityHorse);
    }

    @Override
    public boolean shouldRun() {
        return !this.entityHorse.m_20160_() && this.hasCurrentActionEnded();
    }

    @Override
    public boolean shouldContinueToUse() {
        return !this.entityHorse.m_20160_() && this.hasCurrentActionEnded();
    }

    private boolean hasCurrentActionEnded() {
        return this.currentActionEndTime < System.currentTimeMillis();
    }

    @Override
    public void startGoal() {
        HorseIdleAction actionToPlay = this.determineAction();
        this.entityHorse.setIdleAnimation(actionToPlay.getRandomAnimation());
        this.currentActionEndTime = System.currentTimeMillis() + 1000L * (long)actionToPlay.getDurationSeconds().intValue();
    }

    private HorseIdleAction determineAction() {
        if (this.entityHorse.isInDayTime() || this.entityHorse.getHorseData().getAge().getYears() < 2.0) {
            return ListUtils.getRandom(HorseIdleAction.RESTING, HorseIdleAction.PAWING);
        }
        return HorseIdleAction.RESTING;
    }
}

