/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.illness;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.approval.PlayerApprovalHandler;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.information.HorseIllnessViewInformation;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessMedicineAdapter;
import com.equestricraft.core.illness.IllnessRepository;
import com.equestricraft.core.illness.IllnessSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.item.IllnessDiagnosisTool;
import com.equestricraft.mod.client.item.ModItems;
import com.equestricraft.mod.horse.illness.HorseIllnessDetailsInfo;
import com.equestricraft.mod.horse.illness.IllnessService;
import com.equestricraft.mod.packet.ClientBoundHorseIllnessDetailsMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseIllnessViewMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.TextInputPrompt;
import com.equestricraft.mod.util.ComponentUtil;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class IllnessServiceImpl
implements IllnessService {
    @Service
    private IllnessSession illnessSession;
    @Service
    private IllnessRepository illnessRepository;
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseTransformer horseTransformer;
    private final PlayerApprovalHandler playerApprovalHandler = PlayerApprovalHandler.getInstance();

    @Override
    public Response giveDiagnosisToolToPlayer(OnlinePlayer player) {
        IllnessDiagnosisTool item = ModItems.getIllnessDiagnosisTool();
        ItemStack tool = new ItemStack((ItemLike)item);
        tool.m_41714_((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("illness.diagnosis-tool.name")));
        player.serverPlayer().m_150109_().m_36054_(tool);
        return ResponseFactory.success();
    }

    @Override
    public void showDiagnosedIllnessMenu(ECPlayer player, EQHorse horse) {
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        List<IllnessHorse> illnesses = horse.getIllness().getUncuredOwnerIsAwareOf();
        List<HorseIllnessViewInformation> illnessViews = illnesses.stream().map(i -> this.buildIllnessViewInfo(player, (IllnessHorse)i, false)).toList();
        ClientBoundHorseIllnessViewMenuOpenPacket packet = new ClientBoundHorseIllnessViewMenuOpenPacket(simple, illnessViews, false);
        player.sendPacket(packet);
    }

    @Override
    public void showIllnessDiagnosisMenu(ECPlayer player, EQHorse horse) {
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        List<HorseIllnessViewInformation> illness = horse.getIllness().getUncured().stream().filter(i -> i.getIllness().isDiagnosisNeeded()).filter(i -> this.illnessSession.canSeeAdvancedIllnessInformation(player, i.getIllness())).map(i -> this.buildIllnessViewInfo(player, (IllnessHorse)i, true)).toList();
        ClientBoundHorseIllnessViewMenuOpenPacket packet = new ClientBoundHorseIllnessViewMenuOpenPacket(simple, illness, true);
        player.sendPacket(packet);
    }

    @Override
    public Response showIllnessDetails(ECPlayer player, int horseId, int illnessId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Optional<IllnessHorse> illnessRecord = horse.getIllness().getCurrentRecordForIllness(illnessId);
        if (illnessRecord.isPresent()) {
            IllnessHorse illnessInfo = illnessRecord.get();
            HorseIllnessDetailsInfo details = this.buildInfo(illnessInfo);
            ClientBoundHorseIllnessDetailsMenuOpenPacket packet = new ClientBoundHorseIllnessDetailsMenuOpenPacket(details);
            player.sendPacket(packet);
            return ResponseFactory.success();
        }
        return ResponseFactory.fail(I18n.getLabel("illness.horse-does-not-have-illness"));
    }

    @Override
    public Response diagnoseIllness(ECPlayer player, int horseId, int illnessId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Illness illness = (Illness)this.illnessRepository.findByKey(illnessId);
        double cost = illness.getDiagnosisCost();
        ECPlayer owner = horse.getOwner();
        return this.playerApprovalHandler.executeWithApproval(player, owner, I18n.getLabel("illness.diagnose.approval-message", EconomyUtilities.formatCurrency(cost)), () -> this.diagnoseIllness(player, horse, illness, cost, owner));
    }

    private Response diagnoseIllness(ECPlayer player, EQHorse horse, Illness illness, double cost, ECPlayer owner) {
        boolean moneyTransferNeeded = this.moneyTransferNeeded(illness, player, owner);
        if (moneyTransferNeeded && !owner.getEconomy().hasBalance(cost)) {
            return ResponseFactory.fail(I18n.getLabel("illness.diagnose.owner-not-enough-money"));
        }
        Optional<String> note = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("illness.diagnose.title", illness.getName()), I18n.getLabel("illness.diagnose.enter-note"));
        note.ifPresent(s -> horse.getIllness().addNoteToIllness(illness, (String)s));
        horse.getIllness().makeAwareOfIllness(illness);
        if (moneyTransferNeeded) {
            try {
                owner.getEconomy().sendTo(player, cost, I18n.getLabel("illness.diagnose.economy-transaction", illness.getName(), owner.getIgn()));
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        return ResponseFactory.success(I18n.getLabel("illness.diagnose.title", illness.getName()), I18n.getLabel("illness.diagnose.success", illness.getName()));
    }

    private boolean moneyTransferNeeded(Illness illness, ECPlayer player, ECPlayer owner) {
        if (illness.getDiagnosisCost() == 0.0) {
            return false;
        }
        return !player.equals(owner);
    }

    private HorseIllnessDetailsInfo buildInfo(IllnessHorse illnessHorse) {
        Illness illness = illnessHorse.getIllness();
        List<HorseIllnessDetailsInfo.MedicineInfo> medicines = illness.getMedicines().stream().map(IllnessMedicineAdapter::getMedicine).map(m -> new HorseIllnessDetailsInfo.MedicineInfo(m.getId(), m.getName())).toList();
        return new HorseIllnessDetailsInfo(illness.getId(), illness.getName(), illness.getDescription(), this.buildTimeString(DateUtils.durationSince(illnessHorse.getStartTime())), illnessHorse.getNotes(), medicines);
    }

    private HorseIllnessViewInformation buildIllnessViewInfo(ECPlayer player, IllnessHorse illnessHorse, boolean showCost) {
        boolean canSeeAdvancedInformation = this.illnessSession.canSeeAdvancedIllnessInformation(player, illnessHorse.getIllness());
        return new HorseIllnessViewInformation(illnessHorse.getIllness().getId(), illnessHorse.getIllness().getName(), illnessHorse.getIllness().getDescription(), canSeeAdvancedInformation ? illnessHorse.getIllness().getMessageForTrainedPlayers() : null, this.buildTimeString(this.realTimeDurationHad(illnessHorse)), illnessHorse.getNotes(), showCost ? EconomyUtilities.formatCurrency(illnessHorse.getIllness().getDiagnosisCost()) : null, this.shouldOwnerBeAware(illnessHorse), illnessHorse.getCurePercentage());
    }

    private boolean shouldOwnerBeAware(IllnessHorse illnessHorse) {
        return !illnessHorse.getIllness().isDiagnosisNeeded() || illnessHorse.isAware();
    }

    private Duration realTimeDurationHad(IllnessHorse illnessHorse) {
        return DateUtils.durationSince(illnessHorse.getStartTime());
    }

    public String buildTimeString(Duration duration) {
        long days = duration.toDays();
        long hours = duration.minusDays(days).toHours();
        return String.format("%d days %d hours", days, hours);
    }
}

