/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.instruction;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.instruction.HorseInstructionException;
import com.equestricraft.core.horse.instruction.HorseInstructionType;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.entity.HorseEntitySession;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;

public class HorseInstructionHandler {
    private static final HorseInstructionHandler instance = new HorseInstructionHandler();
    @Service
    private static HorseEntitySession horseEntitySession;

    public static HorseInstructionHandler getInstance() {
        return instance;
    }

    private HorseInstructionHandler() {
    }

    public Response handleInstruction(OnlinePlayer player, UUID entityUuid, HorseInstructionType instructionType, boolean action) {
        EntityHorse horse = horseEntitySession.findHorseByUuid(player.getServerLevel(), entityUuid);
        try {
            if (action) {
                horse.getHorseData().getInstructions().give(instructionType, player);
            } else {
                horse.getHorseData().getInstructions().stop(instructionType);
            }
            return ResponseFactory.success();
        }
        catch (HorseInstructionException ex) {
            return ResponseFactory.fail(ex);
        }
    }
}

