/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.interact;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.action.HorseAction;
import com.equestricraft.core.horse.action.HorseActionExecutePayload;
import com.equestricraft.core.horse.tack.HorseTackService;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.entity.HorseEntitySession;
import com.equestricraft.mod.horse.interact.HorseInteractAction;
import com.equestricraft.mod.horse.mount.HorseMountService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;

public class HorseInteractActionHandler {
    private static final HorseInteractActionHandler instance = new HorseInteractActionHandler();
    private final HorseEntitySession horseEntityService = Services.getService(HorseEntitySession.class);
    private final HorseRepository horseRepository = Services.getService(HorseRepository.class);
    private final HorseMountService horseMountService = Services.getService(HorseMountService.class);
    private final HorseTackService horseTackService = Services.getService(HorseTackService.class);

    public static HorseInteractActionHandler getInstance() {
        return instance;
    }

    private HorseInteractActionHandler() {
    }

    public Response handleInteraction(OnlinePlayer player, UUID entityUuid, HorseInteractAction action) {
        EntityHorse horse = this.horseEntityService.findHorseByUuid(player.getServerLevel(), entityUuid);
        if (action == HorseInteractAction.MOUNT) {
            return this.horseMountService.mountHorse(player, horse);
        }
        if (action == HorseInteractAction.TAP_NOSE) {
            EQHorse h = (EQHorse)this.horseRepository.findByKey(horse.getInternalId());
            h.getActions().processAction(new TapOnNoseAction(h, player));
            return ResponseFactory.success();
        }
        if (action == HorseInteractAction.SCRATCH) {
            EQHorse h = (EQHorse)this.horseRepository.findByKey(horse.getInternalId());
            h.getActions().processAction(new GiveScratchesAction(h, player));
            return ResponseFactory.success();
        }
        if (action == HorseInteractAction.TACK) {
            EQHorse h = (EQHorse)this.horseRepository.findByKey(horse.getInternalId());
            this.horseTackService.showHorseTackMenu(player, h);
            return ResponseFactory.success();
        }
        return ResponseFactory.fail(I18n.getLabel("common.not-implemented-yet"));
    }

    public static class TapOnNoseAction
    extends HorseAction<ActionReaction> {
        public TapOnNoseAction(EQHorse horse, ECPlayer player) {
            super(horse, player);
        }

        @Override
        public HorseActionType getType() {
            return HorseActionType.TAPPED_ON_NOSE;
        }

        @Override
        public ActionReaction buildReaction(boolean reject) {
            return new ActionReaction(reject);
        }

        @Override
        public String getIdentifier() {
            return "tap_on_nose";
        }
    }

    public static class GiveScratchesAction
    extends HorseAction<ActionReaction> {
        public GiveScratchesAction(EQHorse horse, ECPlayer player) {
            super(horse, player);
        }

        @Override
        protected void execute(HorseActionExecutePayload payload) {
            this.horse.getFrustration().decrement(0.1f);
        }

        @Override
        public HorseActionType getType() {
            return HorseActionType.GIVEN_SCRATCHES;
        }

        @Override
        public ActionReaction buildReaction(boolean reject) {
            return new ActionReaction(reject);
        }

        @Override
        public String getIdentifier() {
            return "give_scratches";
        }
    }
}

