/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.interactpolicy;

import com.equestricraft.base.ClickType;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.instruction.HorseInstructionInfo;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.player.menus.HorseMenuService;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.PlayerInteractHorseEvent;
import com.equestricraft.mod.horse.interactpolicy.HorseInteractPolicy;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ClientBoundHorseInstructionGiveMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseInteractMenuOpenPacket;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class StandardHorseInteractPolicy
extends HorseInteractPolicy {
    @Service
    private static HorseRepository horseRepository;
    @Service
    private static HorseMenuService horseMenuService;
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @Override
    public boolean onHorseInteract(EntityHorse horse, ServerPlayer player, ClickType click, boolean shiftKey) {
        if (click == ClickType.LEFT) {
            ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
            TaskScheduler.executeAsyncTask(() -> {
                ECPlayer p = this.onlinePlayerCache.requirePlayer(player.m_142081_());
                EQHorse eqHorse = (EQHorse)horseRepository.findByKey(horse.getInternalId());
                PlayerInteractHorseEvent interactEvent = new PlayerInteractHorseEvent(p, itemInHand, eqHorse, horse);
                MinecraftForge.EVENT_BUS.post((Event)interactEvent);
                if (!interactEvent.isCanceled()) {
                    p.getHorses().setSelected(eqHorse);
                    horseMenuService.showMainMenu(p, eqHorse.getId());
                }
            });
        } else if (click == ClickType.RIGHT) {
            if (shiftKey) {
                TaskScheduler.executeAsyncTask(() -> {
                    ECPlayer p = this.onlinePlayerCache.requirePlayer(player.m_142081_());
                    List<HorseInstructionInfo> instructions = horse.getHorseData().getInstructions().getAvailable(p);
                    ClientBoundHorseInstructionGiveMenuOpenPacket packet = new ClientBoundHorseInstructionGiveMenuOpenPacket(horse.m_142081_(), instructions);
                    Network.sendToPlayer(player, packet);
                });
            } else {
                TaskScheduler.executeAsyncTask(() -> {
                    ECPlayer p = this.onlinePlayerCache.requirePlayer(player.m_142081_());
                    EQHorse eqHorse = (EQHorse)horseRepository.findByKey(horse.getInternalId());
                    p.getHorses().setSelected(eqHorse);
                });
                ClientBoundHorseInteractMenuOpenPacket packet = new ClientBoundHorseInteractMenuOpenPacket(horse.m_142081_());
                Network.sendToPlayer(player, packet);
            }
        }
        return true;
    }
}

