/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.jobwork;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.jobwork.HorseJobWorkSession;
import com.equestricraft.core.horse.jobwork.JobWorkCheckInfo;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSimple;
import com.equestricraft.mod.horse.jobwork.JobWorkService;
import com.equestricraft.mod.packet.ClientBoundJobWorkScreenOpenPacket;
import com.equestricraft.mod.packet.ClientBoundJobsNeedingWorkMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;

public class JobWorkServiceImpl
implements JobWorkService {
    @Service
    private HorseJobWorkSession horseJobWorkSession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private JobRepository jobRepository;
    @Service
    private HorseTransformer horseTransformer;

    @Override
    public void showJobsWithWorkNeedingDone(OnlinePlayer player, EQHorse horse) {
        List<JobSimple> work = this.horseJobWorkSession.retrieveJobsWorkWithWork(horse);
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        ClientBoundJobsNeedingWorkMenuOpenPacket packet = new ClientBoundJobsNeedingWorkMenuOpenPacket(simple, work);
        player.sendPacket(packet);
    }

    @Override
    public Response showJobWorkMenuForJob(OnlinePlayer player, int horseId, int jobId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Job job = (Job)this.jobRepository.findByKey(jobId);
        List<JobWorkCheckInfo> jobWorkChecks = this.horseJobWorkSession.retrieveWorkNeededForJobOnHorse(horse, job);
        ClientBoundJobWorkScreenOpenPacket packet = new ClientBoundJobWorkScreenOpenPacket(job.getName(), jobWorkChecks);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }
}

