/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.leash;

import com.equestricraft.core.horse.EQHorse;
import com.google.common.collect.HashMultimap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.StampedLock;

public class PlayerLeashedHorseCache {
    private static final PlayerLeashedHorseCache instance = new PlayerLeashedHorseCache();
    private final HashMultimap<UUID, EQHorse> leashedHorses = HashMultimap.create();
    private final StampedLock lock = new StampedLock();

    public static PlayerLeashedHorseCache getInstance() {
        return instance;
    }

    private PlayerLeashedHorseCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeashedHorseForPlayer(UUID playerUuid, EQHorse horse) {
        long stamp = this.lock.writeLock();
        try {
            this.leashedHorses.put((Object)playerUuid, (Object)horse);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLeashedHorseFromPlayer(UUID playerUuid, EQHorse horse) {
        long stamp = this.lock.writeLock();
        try {
            this.leashedHorses.remove((Object)playerUuid, (Object)horse);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EQHorse> getPlayersLeasedHorses(UUID playerUuid) {
        long stamp = this.lock.readLock();
        try {
            Set set2 = this.leashedHorses.get((Object)playerUuid);
            return set2;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }
}

