/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.lunge;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.common.Range;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.action.HorseAction;
import com.equestricraft.core.horse.action.HorseActionExecutePayload;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.obedience.ObedienceTrait;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.lunge.LungeAroundPlayerGoal;
import com.equestricraft.mod.horse.lunge.LungeDirection;
import com.equestricraft.mod.horse.speed.HorseSpeedService;
import com.equestricraft.mod.player.OnlinePlayer;
import net.minecraft.world.entity.player.Player;

public class HorseLungeAction
extends HorseAction<ActionReaction> {
    @Service
    private static HorseSpeedService horseSpeedService;
    private static final Range<Integer> lungeRadius;
    private final EntityHorse entityHorse;
    private final HorseSubGait gait;
    private final LungeDirection lungeDirection;

    public HorseLungeAction(EQHorse horse, EntityHorse entityHorse, HorseSubGait gait, OnlinePlayer player, LungeDirection direction) {
        super(horse, player);
        this.entityHorse = entityHorse;
        this.gait = gait;
        this.lungeDirection = direction;
    }

    @Override
    public HorseActionType getType() {
        return HorseActionType.LUNGE;
    }

    @Override
    public boolean canReject() {
        return true;
    }

    @Override
    protected boolean forceReject() {
        float obedience = this.horse.getTraits().getValue(ObedienceTrait.class);
        int trust = this.horse.getTrust().getValue(this.performingPlayer);
        double rejectChance = (double)obedience * (trust >= 50 ? 1.5 : 0.9);
        float intelligence = this.horse.getIntelligence().getValue();
        return (double)this.entityHorse.m_21187_().nextFloat() < (rejectChance *= (double)(1.0f - intelligence));
    }

    @Override
    public void execute(HorseActionExecutePayload payload) {
        horseSpeedService.setHorseSpeed(this.entityHorse, this.gait);
        OnlinePlayer player = this.performingPlayer.require(OnlinePlayer.class);
        int radius = (int)this.entityHorse.m_20182_().m_82554_(player.serverPlayer().m_20182_());
        radius = Math.max(radius, lungeRadius.getLowerBound());
        if (!lungeRadius.containsValueWithin(radius)) {
            return;
        }
        LungeAroundPlayerGoal goal = this.entityHorse.getLungeGoal();
        goal.setRadius(radius);
        goal.setLungeDirection(this.lungeDirection);
        goal.setPlayer((Player)player.serverPlayer());
    }

    @Override
    public ActionReaction buildReaction(boolean reject) {
        return new ActionReaction(reject);
    }

    @Override
    public String getIdentifier() {
        return "lunge";
    }

    static {
        lungeRadius = Range.of(3, 20);
    }
}

