/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.lunge;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.lunge.HorseLungeAroundPlayerEvent;
import com.equestricraft.core.skill.Skill;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.horse.lunge.HorseLungeAction;
import com.equestricraft.mod.horse.lunge.HorseLungeService;
import com.equestricraft.mod.horse.lunge.LungeAroundPlayerGoal;
import com.equestricraft.mod.horse.lunge.LungeDirection;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

public class HorseLungeServiceImpl
implements HorseLungeService {
    @Service
    private StandardHorseEntitySession standardHorseEntitySession;

    @Override
    public void lungeHorse(OnlinePlayer player, EQHorse horse, HorseSubGait gait, LungeDirection direction) {
        if (!horse.getSkill().hasSkill(Skill.LUNGING)) {
            return;
        }
        Optional<EntityHorse> horseEntityOptional = this.standardHorseEntitySession.findEntityForHorse(horse, player.getServerLevel());
        if (horseEntityOptional.isPresent()) {
            EntityHorse horseEntity = horseEntityOptional.get();
            LungeAroundPlayerGoal goal = horseEntity.getLungeGoal();
            if (goal.m_8036_()) {
                return;
            }
            HorseLungeAroundPlayerEvent event = new HorseLungeAroundPlayerEvent(horse, player);
            boolean cancelled = ECEventBus.post(event);
            if (!cancelled) {
                HorseLungeAction action = new HorseLungeAction(horse, horseEntity, gait, player, direction);
                horse.getActions().processAction(action);
            }
        }
    }
}

