/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.lunge;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.Trot;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.horse.lunge.LungeDirection;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class LungeAroundPlayerGoal
extends AbstractHorseGoal {
    private Player player = null;
    private int radius = 0;
    private double halfRadius = 0.0;
    private LungeDirection lungeDirection = LungeDirection.CLOCKWISE;
    private long lungeUntilTime = 0L;
    private static final Vec3 LUNGE_VECTOR = new Vec3(0.0, 1.0, 0.0);

    public LungeAroundPlayerGoal(EntityHorse entityHorse) {
        super(entityHorse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.JUMP));
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.halfRadius = (double)radius / 2.0;
    }

    public void setLungeDirection(LungeDirection lungeDirection) {
        this.lungeDirection = lungeDirection;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isLunging() {
        return this.lungeUntilTime > System.currentTimeMillis();
    }

    @Override
    public boolean shouldRun() {
        return this.radius > 0 && this.player != null;
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.m_8036_() && this.isLunging();
    }

    @Override
    public void startGoal() {
        this.entityHorse.m_21573_().m_26573_();
        this.entityHorse.setGait(Trot.WORKING);
        this.lungeUntilTime = this.determineTimeToUseUntil();
    }

    private long determineTimeToUseUntil() {
        float stamina = this.entityHorse.getHorseData().getStamina().getValue();
        return DateUtils.futureSecondsOffset((int)(60.0f * stamina)).getTime();
    }

    @Override
    public void tickGoal() {
        Vec3 direction = this.entityHorse.m_20182_().m_82542_(1.0, 0.0, 1.0).m_82546_(this.player.m_20182_().m_82542_(1.0, 0.0, 1.0)).m_82541_();
        Vec3 tangent = this.lungeDirection == LungeDirection.CLOCKWISE ? direction.m_82537_(LUNGE_VECTOR) : LUNGE_VECTOR.m_82537_(direction);
        Vec3 target = this.player.m_20182_().m_82549_(direction.m_82542_((double)this.radius, (double)this.radius, (double)this.radius)).m_82549_(tangent.m_82541_().m_82542_(this.halfRadius, this.halfRadius, this.halfRadius));
        this.entityHorse.m_21566_().m_6849_(target.f_82479_, this.getGroundY(target), target.f_82481_, 1.0);
    }

    @Override
    public void stopGoal() {
        this.stopLunge();
        this.entityHorse.m_21573_().m_26573_();
        this.entityHorse.setGait(Halt.DEFAULT);
    }

    public void stopLunge() {
        this.lungeUntilTime = 0L;
        this.radius = 0;
        this.player = null;
    }

    private double getGroundY(Vec3 vec) {
        BlockPos blockpos = new BlockPos(vec);
        return this.entityHorse.f_19853_.m_8055_(blockpos.m_7495_()).m_60795_() ? vec.f_82480_ : WalkNodeEvaluator.m_77611_((BlockGetter)this.entityHorse.f_19853_, (BlockPos)blockpos);
    }
}

