/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.lunge;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Trot;
import com.equestricraft.core.skill.Skill;
import com.equestricraft.mod.horse.leash.PlayerLeashedHorseCache;
import com.equestricraft.mod.horse.lunge.HorseLungeService;
import com.equestricraft.mod.horse.lunge.LungeDirection;
import com.equestricraft.mod.movement.PlayerMoveEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class LungeListener {
    @Service
    private static HorseLungeService horseLungeService;
    private static final PlayerLeashedHorseCache playerLeashedHorseCache;

    @SubscribeEvent
    public static void onPlayerMove(PlayerMoveEvent event) {
        TaskScheduler.executeAsyncTask(() -> {
            Set<EQHorse> leashedHorses;
            OnlinePlayer player = event.getPlayer();
            if (!player.getSkills().hasSkill(Skill.LUNGING)) {
                return;
            }
            ServerPlayer serverPlayer = player.serverPlayer();
            Optional<LungeDirection> lungeDirection = LungeListener.determineLungeDirection(serverPlayer.m_6350_(), event.getLastLocation(), event.getNextLocation());
            if (lungeDirection.isPresent() && !(leashedHorses = playerLeashedHorseCache.getPlayersLeasedHorses(player.getAccountUuid())).isEmpty()) {
                for (EQHorse horse : leashedHorses) {
                    horseLungeService.lungeHorse(player, horse, Trot.WORKING, lungeDirection.get());
                }
            }
        });
    }

    private static Optional<LungeDirection> determineLungeDirection(Direction facingDirection, Coordinate oldCoordinate, Coordinate newCoordinate) {
        Direction movingDirection = LungeListener.movementDirection(oldCoordinate, newCoordinate);
        if (movingDirection == null) {
            return Optional.empty();
        }
        if (facingDirection.m_122428_().equals((Object)movingDirection)) {
            return Optional.of(LungeDirection.ANTI_CLOCKWISE);
        }
        if (facingDirection.m_122427_().equals((Object)movingDirection)) {
            return Optional.of(LungeDirection.CLOCKWISE);
        }
        return Optional.empty();
    }

    private static Direction movementDirection(Coordinate oldCoordinate, Coordinate newCoordinate) {
        double deltaX = newCoordinate.x() - oldCoordinate.x();
        double deltaZ = newCoordinate.z() - oldCoordinate.z();
        if (deltaX > 0.0) {
            if (deltaX > Math.abs(deltaZ)) {
                return Direction.EAST;
            }
        } else if (deltaX < 0.0 && Math.abs(deltaX) > Math.abs(deltaZ)) {
            return Direction.WEST;
        }
        if (deltaZ > 0.0) {
            if (deltaZ > Math.abs(deltaX)) {
                return Direction.SOUTH;
            }
        } else if (deltaZ < 0.0 && Math.abs(deltaZ) > Math.abs(deltaX)) {
            return Direction.NORTH;
        }
        return null;
    }

    private LungeListener() {
    }

    static {
        playerLeashedHorseCache = PlayerLeashedHorseCache.getInstance();
    }
}

