/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.menu;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.illness.IllnessSymptomInformation;
import com.equestricraft.core.horse.information.HorseBasicViewDetails;
import com.equestricraft.core.horse.information.HorseBreedCertificateInformation;
import com.equestricraft.core.horse.information.HorseCertificatesInfo;
import com.equestricraft.core.horse.information.HorseDetailsInformation;
import com.equestricraft.core.horse.information.HorseInformationViewSession;
import com.equestricraft.core.horse.information.HorseParentalViewInformation;
import com.equestricraft.core.horse.information.HorseStatsInformation;
import com.equestricraft.core.horse.information.HorseVitaminInformation;
import com.equestricraft.core.horse.information.HorseWelfareInformation;
import com.equestricraft.core.horse.medicine.HorseMedicineInformation;
import com.equestricraft.core.horse.registration.HorseRegistrationCertificateDetails;
import com.equestricraft.core.horse.registration.HorseRegistrationSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.menus.HorseMenuService;
import com.equestricraft.mod.horse.access.HorseAccessService;
import com.equestricraft.mod.horse.conformation.HorseConformationService;
import com.equestricraft.mod.horse.discipline.HorseDisciplineService;
import com.equestricraft.mod.horse.illness.IllnessService;
import com.equestricraft.mod.horse.jobwork.JobWorkService;
import com.equestricraft.mod.horse.sell.HorseSaleHistoryService;
import com.equestricraft.mod.horse.skill.HorseSkillService;
import com.equestricraft.mod.horse.weight.HorseWeightLogService;
import com.equestricraft.mod.packet.ClientBoundHorseBreedCertificateMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseCertificateMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseDetailsViewMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseMedicinesViewMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseParentViewMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseRegistrationCertificateOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseStatsMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseSymptomsViewMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseViewMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseVitaminViewMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseWelfareMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;

public class HorseMenuServiceImpl
implements HorseMenuService {
    @Service
    private HorseInformationViewSession horseInformationViewSession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseAccessService horseAccessService;
    @Service
    private IllnessService illnessService;
    @Service
    private HorseDisciplineService horseDisciplineService;
    @Service
    private HorseConformationService horseConformationService;
    @Service
    private HorseSaleHistoryService horseSaleHistoryService;
    @Service
    private HorseWeightLogService horseWeightLogService;
    @Service
    private HorseRegistrationSession horseRegistrationSession;
    @Service
    private JobWorkService jobWorkService;
    @Service
    private HorseSkillService horseSkillService;
    @Service
    private HorseTransformer horseTransformer;

    @Override
    public void showMenu(ECPlayer player, int horseId, String menu) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        this.showMenu(player, horse, menu);
    }

    @Override
    public void showMenu(ECPlayer player, EQHorse horse, String menu) {
        switch (menu) {
            case "MAIN": {
                this.showMainMenu(player, horse);
                break;
            }
            case "DETAILS": {
                this.showDetailsMenu(player, horse);
                break;
            }
            case "HEALTH": {
                this.showWelfareMenu(player, horse);
                break;
            }
            case "SYMPTOMS": {
                this.showSymptomsMenu(player, horse);
                break;
            }
            case "MEDICINES": {
                this.showMedicinesMenu(player, horse);
                break;
            }
            case "PARENTS": {
                this.showParentsMenu(player, horse);
                break;
            }
            case "BREEDS": {
                this.showBreedCertificate(player, horse);
                break;
            }
            case "VITAMINS": {
                this.showNutritionMenu(player, horse);
                break;
            }
            case "ILLNESSES": {
                this.showIllnessMenu(player, horse);
                break;
            }
            case "PLAYER_ACCESS": {
                this.showPlayerAccessMenu(player, horse);
                break;
            }
            case "STATS": {
                this.showHorseStatsMenu(player, horse);
                break;
            }
            case "DISCIPLINES": {
                this.showHorseDisciplinesMenu(player, horse);
                break;
            }
            case "CONFORMATION": {
                this.showHorseConformationMenu(player, horse);
                break;
            }
            case "SALE_HISTORY": {
                this.showSaleHistoryMenu(player, horse);
                break;
            }
            case "WEIGHT_LOG": {
                this.showWeightLogMenu(player, horse);
                break;
            }
            case "REGISTRATION_CERTIFICATE": {
                this.showRegistrationCertificateMenu(player, horse);
                break;
            }
            case "WORK_NEEDING_DONE_MAIN": {
                this.showWorkNeedingDoneMainMenu(player, horse);
                break;
            }
            case "CERTIFICATES": {
                this.showCertificatesMenu(player, horse);
                break;
            }
            case "SKILLS": {
                this.showSkillsMenu(player, horse);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid menu: %s", menu));
            }
        }
    }

    @Override
    public void showMainMenu(ECPlayer player, int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        this.openMenuForHorse(player, horse);
    }

    @Override
    public Response showMainMenu(ECPlayer player, EQHorse horse) {
        this.openMenuForHorse(player, horse);
        return ResponseFactory.success();
    }

    @Override
    public Response showMainMenu(ECPlayer player, String name) {
        EQHorse horse = player.getHorses().getHorseByName(name);
        this.openMenuForHorse(player, horse);
        return ResponseFactory.success();
    }

    private void openMenuForHorse(ECPlayer player, EQHorse horse) {
        HorseBasicViewDetails data = this.horseInformationViewSession.retrieveBasicInformationForHorse(player, horse);
        ClientBoundHorseViewMenuOpenPacket packet = new ClientBoundHorseViewMenuOpenPacket(horse.getId(), data);
        player.sendPacket(packet);
    }

    private void showDetailsMenu(ECPlayer player, EQHorse horse) {
        HorseDetailsInformation details = this.horseInformationViewSession.retrieveHorseDetails(player, horse);
        ClientBoundHorseDetailsViewMenuOpenPacket packet = new ClientBoundHorseDetailsViewMenuOpenPacket(horse.getId(), details);
        player.sendPacket(packet);
    }

    private void showParentsMenu(ECPlayer player, EQHorse horse) {
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        HorseParentalViewInformation parentInfo = this.horseInformationViewSession.retrieveParentalInformation(horse);
        ClientBoundHorseParentViewMenuOpenPacket packet = new ClientBoundHorseParentViewMenuOpenPacket(simple, parentInfo);
        player.sendPacket(packet);
    }

    private void showBreedCertificate(ECPlayer player, EQHorse horse) {
        HorseBreedCertificateInformation info2 = this.horseInformationViewSession.retrieveBreedInformation(horse);
        ClientBoundHorseBreedCertificateMenuOpenPacket packet = new ClientBoundHorseBreedCertificateMenuOpenPacket(info2);
        player.sendPacket(packet);
    }

    private void showWelfareMenu(ECPlayer player, EQHorse horse) {
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        HorseWelfareInformation welfare = this.horseInformationViewSession.retrieveWelfareInformation(player, horse);
        ClientBoundHorseWelfareMenuOpenPacket packet = new ClientBoundHorseWelfareMenuOpenPacket(simple, welfare);
        player.sendPacket(packet);
    }

    private void showSymptomsMenu(ECPlayer player, EQHorse horse) {
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        List<IllnessSymptomInformation> symptoms = horse.getSymptoms().retrieveSymptomInformationForPlayer(player);
        ClientBoundHorseSymptomsViewMenuOpenPacket packet = new ClientBoundHorseSymptomsViewMenuOpenPacket(simple, symptoms);
        player.sendPacket(packet);
    }

    private void showMedicinesMenu(ECPlayer player, EQHorse horse) {
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        List<HorseMedicineInformation> medicines = this.horseInformationViewSession.retrieveMedicineInformation(player, horse);
        ClientBoundHorseMedicinesViewMenuOpenPacket packet = new ClientBoundHorseMedicinesViewMenuOpenPacket(simple, medicines);
        player.sendPacket(packet);
    }

    private void showNutritionMenu(ECPlayer player, EQHorse horse) {
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        List<HorseVitaminInformation> nutrition = this.horseInformationViewSession.retrieveHorseVitaminInformation(player.getId(), horse);
        ClientBoundHorseVitaminViewMenuOpenPacket packet = new ClientBoundHorseVitaminViewMenuOpenPacket(simple, nutrition);
        player.sendPacket(packet);
    }

    private void showIllnessMenu(ECPlayer player, EQHorse horse) {
        this.illnessService.showDiagnosedIllnessMenu(player, horse);
    }

    private void showPlayerAccessMenu(ECPlayer player, EQHorse horse) {
        Response response = this.horseAccessService.showHorseAccessMenu(player, horse, 1);
        player.showResponseIfFail(response);
    }

    private void showHorseStatsMenu(ECPlayer player, EQHorse horse) {
        HorseStatsInformation data = this.horseInformationViewSession.retrieveHorseStatsInformation(player, horse);
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        ClientBoundHorseStatsMenuOpenPacket packet = new ClientBoundHorseStatsMenuOpenPacket(simple, data);
        player.sendPacket(packet);
    }

    private void showHorseDisciplinesMenu(ECPlayer player, EQHorse horse) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        this.horseDisciplineService.showHorsesDisciplinesMenu(onlinePlayer, horse);
    }

    private void showHorseConformationMenu(ECPlayer player, EQHorse horse) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        this.horseConformationService.showConformationCheckScreen(onlinePlayer, horse);
    }

    private void showSaleHistoryMenu(ECPlayer player, EQHorse horse) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        this.horseSaleHistoryService.showHorseSaleHistoryMenu(onlinePlayer, horse, 1, SortDirection.ASCENDING);
    }

    private void showWeightLogMenu(ECPlayer player, EQHorse horse) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        this.horseWeightLogService.showHorseWeightLogPage(onlinePlayer, horse, 1, SortDirection.ASCENDING);
    }

    private void showRegistrationCertificateMenu(ECPlayer player, EQHorse horse) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        HorseRegistrationCertificateDetails details = this.horseRegistrationSession.getHorsesRegistrationCertificateDetails(horse).orElseThrow();
        ClientBoundHorseRegistrationCertificateOpenPacket packet = new ClientBoundHorseRegistrationCertificateOpenPacket(details);
        onlinePlayer.sendPacket(packet);
    }

    private void showWorkNeedingDoneMainMenu(ECPlayer player, EQHorse horse) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        this.jobWorkService.showJobsWithWorkNeedingDone(onlinePlayer, horse);
    }

    private void showCertificatesMenu(ECPlayer player, EQHorse horse) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        HorseCertificatesInfo details = this.horseInformationViewSession.retrieveHorseCertificateInfo(player, horse);
        ClientBoundHorseCertificateMenuOpenPacket packet = new ClientBoundHorseCertificateMenuOpenPacket(simple, details);
        onlinePlayer.sendPacket(packet);
    }

    private void showSkillsMenu(ECPlayer player, EQHorse horse) {
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        this.horseSkillService.showHorseSkillsScreenToPlayer(onlinePlayer, horse);
    }
}

