/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.mount;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.mount.HorseMountService;
import com.equestricraft.mod.horse.mountpolicy.HorseMountPolicy;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class HorseMountServiceImpl
implements HorseMountService {
    private static final int MOUNT_BOX_RADIUS = 2;

    @Override
    public Response mountNearbyHorse(OnlinePlayer player) {
        ServerPlayer serverPlayer = player.serverPlayer();
        if (serverPlayer.m_20202_() == null) {
            return this.mountNearestHorse(player);
        }
        return ResponseFactory.fail();
    }

    @Override
    public Response mountHorse(OnlinePlayer player, EntityHorse horse) {
        HorseMountPolicy policy = horse.getMountPolicy();
        return policy.onMount(horse, player);
    }

    private Response mountNearestHorse(OnlinePlayer player) {
        Optional<EntityHorse> nearestHorse = this.findNearestHorse(player.serverPlayer());
        if (nearestHorse.isPresent()) {
            EntityHorse horse = nearestHorse.get();
            return this.mountHorse(player, horse);
        }
        return ResponseFactory.fail(I18n.getLabel("horse.mount.no-nearby-horse"));
    }

    private Optional<EntityHorse> findNearestHorse(ServerPlayer player) {
        List horses = player.f_19853_.m_45971_(EntityHorse.class, TargetingConditions.m_148353_(), (LivingEntity)player, new AABB(player.m_142538_()).m_82400_(2.0));
        if (horses.isEmpty()) {
            return Optional.empty();
        }
        record HorseDistance(EntityHorse horse, double distanceToPlayer) {
        }
        return horses.stream().filter(h -> h.getMountPolicy().canMount((EntityHorse)h)).map(h -> new HorseDistance((EntityHorse)h, h.m_20270_((Entity)player))).min(Comparator.comparingDouble(HorseDistance::distanceToPlayer)).map(HorseDistance::horse);
    }
}

