/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.mountpolicy;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.skill.Skill;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.mountpolicy.HorseMountPolicy;
import com.equestricraft.mod.horse.ride.HorseMountAction;
import com.equestricraft.mod.horse.ride.HorseRideService;
import com.equestricraft.mod.player.OnlinePlayer;

public class StandardHorseMountPolicy
extends HorseMountPolicy {
    @Service
    private static HorseRideService horseRideService;

    @Override
    public boolean canMount(EntityHorse horse) {
        return true;
    }

    @Override
    public Response onMount(EntityHorse horse, OnlinePlayer player) {
        Response response;
        EQHorse h = horse.getHorseData();
        if (h.getTacks().getSaddle().isEmpty()) {
            if (!player.getSkills().hasSkill(Skill.BAREBACK_RIDING)) {
                return ResponseFactory.fail(I18n.getLabel("horse.mount.bareback.skill-not-learned.player"));
            }
            if (!h.getSkill().hasSkill(Skill.BAREBACK_RIDING)) {
                return ResponseFactory.fail(I18n.getLabel("horse.mount.bareback.skill-not-learned.horse"));
            }
        }
        if ((response = horseRideService.startRide(h, horse, player)).isSuccess()) {
            HorseSubGait gait = horse.getGait();
            player.getDisplay().getCurrentGait().showGait(gait);
            player.getHorses().setRiding(h);
            h.getCurrentRide().setPlayer(player);
            HorseMountAction action = new HorseMountAction(h, player, horse);
            h.getActions().processAction(action);
        } else {
            player.showResponse(response);
        }
        return ResponseFactory.success();
    }
}

