/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.prescription;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.prescription.PrescriptionRequest;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessMedicine;
import com.equestricraft.core.illness.IllnessRepository;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineRepository;
import com.equestricraft.mod.horse.prescription.HorsePrescriptionPage;
import com.equestricraft.mod.horse.prescription.PrescriptionHorsePageSession;
import com.equestricraft.mod.horse.prescription.PrescriptionMedicineItem;
import com.equestricraft.mod.horse.prescription.PrescriptionService;
import com.equestricraft.mod.packet.ClientBoundPrescriptionGiveMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundPrescriptionListMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.NumberInputPrompt;
import java.util.List;

public class PrescriptionServiceImpl
implements PrescriptionService {
    @Service
    private PrescriptionHorsePageSession prescriptionHorsePageSession;
    @Service
    private IllnessRepository illnessRepository;
    @Service
    private HorseRepository horseRepository;
    @Service
    private MedicineRepository medicineRepository;

    @Override
    public Response showPrescriptionGiveMenu(OnlinePlayer player, int horseId, int illnessId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Illness illness = (Illness)this.illnessRepository.findByKey(illnessId);
        List<PrescriptionMedicineItem> items = illness.getMedicines().stream().map(this::buildItem).toList();
        ClientBoundPrescriptionGiveMenuOpenPacket packet = new ClientBoundPrescriptionGiveMenuOpenPacket(horseId, horse.getName(), illnessId, illness.getName(), items);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    private PrescriptionMedicineItem buildItem(IllnessMedicine illnessMedicine) {
        Medicine medicine = illnessMedicine.getMedicine();
        return new PrescriptionMedicineItem(medicine.getId(), medicine.getName(), medicine.getDescription(), illnessMedicine.getCuringPercentageGain());
    }

    @Override
    public Response sendPrescription(OnlinePlayer player, int horseId, int illnessId, String description, List<Integer> medicineIds) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        PrescriptionRequest.Builder requestBuilder = PrescriptionRequest.start(horse).withDescription(description);
        List medicines = this.medicineRepository.findByKeys(medicineIds);
        for (Medicine medicine : medicines) {
            int dosageSize = NumberInputPrompt.showNumberInputPrompt(player, I18n.getLabel("prescription.give.menu.title"), I18n.getLabel("prescription.give.enter-dosage", medicine.getDosageUnitName(), medicine.getName())).orElseThrow().intValue();
            int durationHours = NumberInputPrompt.showNumberInputPrompt(player, I18n.getLabel("prescription.give.menu.title"), I18n.getLabel("prescription.give.enter-duration-hours", medicine.getName())).orElseThrow().intValue();
            requestBuilder.withMedicine(medicine, dosageSize, medicine.getMaximumOverdoseStartSize(), durationHours);
        }
        horse.getPrescriptions().givePrescription(requestBuilder.complete());
        return ResponseFactory.success(I18n.getLabel("prescription.give.success"));
    }

    @Override
    public Response showPrescriptionsForHorse(OnlinePlayer player, int horseId, int pageNumber, SortDirection sortDirection) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        HorsePrescriptionPage page = this.prescriptionHorsePageSession.retrievePageOfHorsesPrescriptions(horse, pageNumber, sortDirection);
        ClientBoundPrescriptionListMenuOpenPacket packet = new ClientBoundPrescriptionListMenuOpenPacket(horseId, page);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }
}

