/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.progression;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.progression.HorseProgressionMilestone;
import com.equestricraft.core.horse.progression.HorseProgressionMilestoneSession;
import com.equestricraft.mod.horse.progression.HorseProgressionMilestoneInfo;
import com.equestricraft.mod.horse.progression.HorseProgressionService;
import com.equestricraft.mod.packet.ClientBoundHorseProgressionMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;

public class HorseProgressionServiceImpl
implements HorseProgressionService {
    @Service
    private HorseProgressionMilestoneSession horseProgressionMilestoneSession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseTransformer horseTransformer;

    @Override
    public Response showHorseProgressionMenu(OnlinePlayer player, int horseId) {
        List<HorseProgressionMilestone> milestones = this.horseProgressionMilestoneSession.getMilestones();
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        List<HorseProgressionMilestoneInfo> milestoneInfoList = milestones.stream().map(m -> new HorseProgressionMilestoneInfo(m.getName(), m.getGroup(), m.getXpRequired(), horse.getXpValue() >= m.getXpRequired())).toList();
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        ClientBoundHorseProgressionMenuOpenPacket packet = new ClientBoundHorseProgressionMenuOpenPacket(simple, milestoneInfoList);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }
}

