/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.registry;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.NotEnoughMoneyException;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSession;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.death.HorseDeathAlreadyRegisteredException;
import com.equestricraft.core.horse.death.HorseNotDeadException;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.horse.registration.HorseRegistrationCertificateDetails;
import com.equestricraft.core.horse.registration.HorseRegistrationSession;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.horse.dead.DeadHorseSelectPrompt;
import com.equestricraft.mod.horse.registry.HorseRegistryService;
import com.equestricraft.mod.packet.ClientBoundHorseRegistrationCertificateOpenPacket;
import com.equestricraft.mod.packet.ClientBoundHorseRegistryMainMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.TextInputPrompt;
import java.util.Optional;

public class HorseRegistryServiceImpl
implements HorseRegistryService {
    @Service
    private HorseSession horseSession;
    @Service
    private HorseRegistrationSession horseRegistrationSession;

    @Override
    public Response lookupRegistration(OnlinePlayer player) {
        Optional<String> registration = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("horse.registry-office.lookup.title"), I18n.getLabel("horse.registry-office.lookup.enter-number"));
        if (registration.isPresent()) {
            Optional<HorseRegistrationCertificateDetails> details = this.horseRegistrationSession.lookupHorseRegistration(registration.get());
            if (details.isPresent()) {
                ClientBoundHorseRegistrationCertificateOpenPacket packet = new ClientBoundHorseRegistrationCertificateOpenPacket(details.get());
                player.sendPacket(packet);
                return ResponseFactory.success();
            }
            return ResponseFactory.fail(I18n.getLabel("horse.registry-office.lookup.title"), I18n.getLabel("horse.registry-office.lookup.not-found", registration.get()), () -> this.lookupRegistration(player));
        }
        return ResponseFactory.fail();
    }

    @Override
    public void showRegistryMenuToPlayer(OnlinePlayer onlinePlayer) {
        ClientBoundHorseRegistryMainMenuOpenPacket packet = new ClientBoundHorseRegistryMainMenuOpenPacket(FeatureFlag.DEATH_REGISTRATION.isEnabled());
        onlinePlayer.sendPacket(packet);
    }

    @Override
    public Response registerDeathForHorse(OnlinePlayer onlinePlayer) {
        Optional<EQHorse> horse = DeadHorseSelectPrompt.showPrompt(onlinePlayer);
        if (horse.isPresent()) {
            EQHorse h = horse.get();
            HorsePermissionChecker.ensureHasPermissionLevel(onlinePlayer, h, HorsePermissionLevel.OWNER);
            try {
                double cost = HorseSettings.getDeathRegistrationCost();
                if (!onlinePlayer.getEconomy().hasBalance(cost)) {
                    throw new NotEnoughMoneyException();
                }
                this.horseSession.registerDeath(h);
                SingleAccountEconomyResponse economyResponse = onlinePlayer.getEconomy().withdraw(cost, I18n.getLabel("horse.death-registration.money-transaction.text", h.getName()), "Death Registration");
                return ResponseFactory.success(I18n.getLabel("horse.death-registration.register.success.prompt.title"), I18n.getLabel("horse.death-registration.register.success.prompt.message", h.getName(), economyResponse.amountFormatted(), economyResponse.balanceFormatted()));
            }
            catch (EconomyException | HorseDeathAlreadyRegisteredException | HorseNotDeadException ex) {
                return ResponseFactory.fail(I18n.getLabel("horse.death-registration.register.fail.prompt.title"), ex);
            }
        }
        return ResponseFactory.fail();
    }
}

