/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.ride;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.TrustAction;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.ProbabilityUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.gait.Gallop;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.nutrient.HorseNutritionUpdateSession;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.horse.ride.HorseCurrentRide;
import com.equestricraft.core.horse.ride.HorseGaitTimes;
import com.equestricraft.core.horse.ride.HorseRideCache;
import com.equestricraft.core.horse.ride.PlayerRideRecord;
import com.equestricraft.core.horse.ridelog.HorseRideLogSession;
import com.equestricraft.core.horse.tack.HorseTackSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.shoe.HorseShoe;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.ride.HorseRideService;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Optional;

public class HorseRideServiceImpl
implements HorseRideService {
    @Service
    private HorseRideLogSession horseRideLogSession;
    @Service
    private HorseNutritionUpdateSession horseNutritionUpdateSession;
    @Service
    private HorseTackSession horseTackSession;
    private final HorseRideCache horseRideCache = HorseRideCache.getInstance();
    private static final Log log = Log.getLogger(HorseRideServiceImpl.class.getName());

    @Override
    public Response startRide(EQHorse horse, EntityHorse entityHorse, ECPlayer player) {
        if (!HorsePermissionChecker.hasPermissionLevel(player, horse, HorsePermissionLevel.BASIC)) {
            return ResponseFactory.fail(I18n.getLabel("horse.no-permission"));
        }
        if (horse.getStallRest().isActive()) {
            return ResponseFactory.fail(I18n.getLabel("horse.stall-rest.cannot-ride"));
        }
        if (this.testStressLevel(horse, player)) {
            return ResponseFactory.fail(I18n.getLabel("horse.too-stressed-to-ride"));
        }
        horse.getCurrentRide().startRide();
        PlayerRideRecord rideRecord = new PlayerRideRecord(horse.getId(), new Date());
        this.horseRideCache.addRideRecord(player.getId(), rideRecord);
        TaskScheduler.executeAsyncTask(() -> this.updateNutrition(horse));
        player.getHorses().setSelected(horse);
        entityHorse.setMaximumYRotation(this.getMaximumYRotationPerTick(horse));
        return ResponseFactory.success();
    }

    private boolean testStressLevel(EQHorse horse, ECPlayer player) {
        float stressStartLevel = horse.getTrust().getValue(player) > 50 ? 0.7f : 0.5f;
        float horseStress = horse.getStress().getValue();
        if (horseStress >= stressStartLevel) {
            return ProbabilityUtils.testPercentageProbability(horseStress);
        }
        return false;
    }

    private float getMaximumYRotationPerTick(EQHorse horse) {
        float zeroSteeringControls = HorseSettings.getMaximumYRotationNoSteering().floatValue();
        float fullSteeringControls = HorseSettings.getMaximumYRotationFullSteering().floatValue();
        double steering = horse.getControl().getSteeringValue();
        return (float)((double)fullSteeringControls + (1.0 - steering) * (double)(zeroSteeringControls - fullSteeringControls));
    }

    private void updateNutrition(EQHorse horse) {
        long idleTime = DateUtils.millisSince(horse.getLastNutritionReduction());
        double hours = (double)idleTime / 3600000.0;
        this.horseNutritionUpdateSession.takeNutrientsForIdleHours(horse, hours);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRide(EQHorse horse, ECPlayer player, boolean positiveEnd) {
        PlayerRideRecord rideRecord = this.horseRideCache.getRideRecord(player.getId());
        if (rideRecord == null) {
            log.warn("Player {} dismounted horse {} but there is no record of mounting", (Object)player, (Object)horse);
            return;
        }
        if (rideRecord.horseId() != horse.getId()) {
            log.warn("Player {} dismounted horse {} but was expecting horse {}", player, horse, rideRecord.horseId());
            return;
        }
        try {
            HorseShoe s;
            Date endTime = new Date();
            this.horseRideLogSession.logHorseRide(horse, player, rideRecord.startTime(), endTime);
            HorseCurrentRide currentRide = horse.getCurrentRide().getCurrentRide();
            HorseGaitTimes gaitTimes = currentRide.getGaitTimes();
            this.horseNutritionUpdateSession.takeNutrientsForSpeeds(horse, gaitTimes);
            Duration rideDuration = Duration.ofMillis(endTime.getTime() - rideRecord.startTime().getTime());
            long minutes = rideDuration.toMinutes();
            if (positiveEnd) {
                horse.getTrust().processAction(player, TrustAction.RIDING, (int)minutes);
            }
            this.horseTackSession.increaseWearForTack(horse, rideDuration);
            horse.getHooves().addWearForRideDuration(rideDuration);
            Optional<HorseShoe> shoe = horse.getShoes().getShoe();
            if (shoe.isPresent() && NumberUtils.testProbability((s = shoe.get()).getFallOffPercentage()) && NumberUtils.testProbability(5)) {
                horse.getShoes().removeOneShoe();
            }
            int horseXp = this.calculateHorseXp(gaitTimes);
            horse.getProgression().give(horseXp);
            int playerXp = this.calculatePlayerXp(gaitTimes);
            player.getProgression().hasXp(playerXp);
            this.adjustFrustration(horse, gaitTimes);
        }
        finally {
            this.horseRideCache.removeRideRecord(player.getId());
            horse.getCurrentRide().clear();
        }
    }

    private int calculateHorseXp(HorseGaitTimes gaitTimes) {
        int totalMinutesSpentRiding = this.calculateMinutesSpentRiding(gaitTimes);
        return totalMinutesSpentRiding * HorseSettings.getXpPerRidingMinute();
    }

    private int calculatePlayerXp(HorseGaitTimes gaitTimes) {
        int totalMinutesSpentRiding = this.calculateMinutesSpentRiding(gaitTimes);
        return totalMinutesSpentRiding * HorseSettings.getXpPlayerPerRidingMinute();
    }

    private int calculateMinutesSpentRiding(HorseGaitTimes gaitTimes) {
        Duration durationSpentMoving = Duration.ZERO;
        for (Map.Entry entry : gaitTimes.entrySet()) {
            HorseSubGait gait = (HorseSubGait)entry.getKey();
            Duration durationForGait = (Duration)entry.getValue();
            if (gait == Halt.DEFAULT) continue;
            durationSpentMoving = durationSpentMoving.plus(durationForGait);
        }
        return (int)durationSpentMoving.toMinutes();
    }

    private void adjustFrustration(EQHorse horse, HorseGaitTimes gaitTimes) {
        Duration gallopFull = gaitTimes.get(Gallop.FULL);
        Duration gallopHand = gaitTimes.get(Gallop.HAND);
        Duration totalGallopTime = gallopFull.plus(gallopHand);
        Duration totalTime = gaitTimes.values().stream().reduce(Duration.ZERO, Duration::plus);
        if ((double)totalGallopTime.toMillis() / (double)totalTime.toMillis() > 0.5) {
            horse.getFrustration().decrement(0.5f);
        }
    }
}

