/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.ride;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Canter;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.gait.Walk;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.ride.HorseDismountEvent;
import com.equestricraft.mod.horse.ride.HorseRideService;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.player.display.PlayerDisplay;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class HorseRidingListener {
    @Service
    private static HorseRideService horseRideService;

    @SubscribeEvent
    public static void endRide(HorseDismountEvent event) {
        EQHorse horse = event.getHorse();
        ECPlayer player = event.getPlayer();
        EntityHorse entityHorse = event.getEntityHorse();
        horseRideService.endRide(horse, player, !entityHorse.didLastRideEndBadly());
        entityHorse.getSpeedDecreaseHandler().cancel();
        PlayerDisplay playerDisplay = player.require(OnlinePlayer.class).getDisplay();
        playerDisplay.getCurrentGait().clearGait();
        playerDisplay.getHorseStamina().hide();
        playerDisplay.getLeadDisplay().clear();
        player.getHorses().setRiding(null);
        HorseSubGait currentGait = entityHorse.getGait();
        if (currentGait.getBlocksPerSecond() != 0.0f) {
            if (currentGait.getBlocksPerSecond() < 0.0f) {
                entityHorse.setGait(Walk.WORKING);
            }
            if (currentGait.getBlocksPerSecond() >= Canter.COLLECTED.getBlocksPerSecond()) {
                entityHorse.getSlowDownStraightGoal().activate();
            }
        }
        entityHorse.clearBadRideEnd();
    }

    private HorseRidingListener() {
    }
}

