/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.sell;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.sale.log.HorseSalePage;
import com.equestricraft.core.horse.sale.log.HorseSalePaginationSession;
import com.equestricraft.mod.horse.sell.HorseSaleHistoryService;
import com.equestricraft.mod.packet.ClientBoundHorseSaleHistoryOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;

public class HorseSaleHistoryServiceImpl
implements HorseSaleHistoryService {
    @Service
    private HorseSalePaginationSession horseSalePaginationSession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseTransformer horseTransformer;

    @Override
    public Response showHorseSaleHistoryMenu(OnlinePlayer player, int horseId, int pageNumber, SortDirection sortDirection) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        return this.showHorseSaleHistoryMenu(player, horse, pageNumber, sortDirection);
    }

    @Override
    public Response showHorseSaleHistoryMenu(OnlinePlayer player, EQHorse horse, int pageNumber, SortDirection sortDirection) {
        HorseSalePage page = this.horseSalePaginationSession.retrieveHorseSalePage(horse.getId(), pageNumber, sortDirection);
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        ClientBoundHorseSaleHistoryOpenPacket packet = new ClientBoundHorseSaleHistoryOpenPacket(simple, page);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }
}

