/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.sell;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.command.UpdateHorseNameCommand;
import com.equestricraft.core.horse.sale.HorseSaleResponse;
import com.equestricraft.core.horse.sale.HorseSellException;
import com.equestricraft.core.horse.sale.HorseSellSession;
import com.equestricraft.core.horse.sale.PreSaleInfo;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.horse.sell.HorseSellService;
import com.equestricraft.mod.packet.ClientBoundHorseSellMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

public class HorseSellServiceImpl
implements HorseSellService {
    @Service
    private HorseSellSession horseSellSession;
    @Service
    private HorseRepository horseRepository;
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @Override
    public Response startHorseSellProcess(ECPlayer playerSelling, EQHorse horse, String sellingToPlayerIgn) {
        Optional<ECPlayer> sellingToPlayer = this.onlinePlayerCache.getPlayer(sellingToPlayerIgn);
        if (sellingToPlayer.isPresent()) {
            PreSaleInfo preSaleInfo = this.horseSellSession.getPreSaleInformation(horse);
            ClientBoundHorseSellMenuOpenPacket packet = new ClientBoundHorseSellMenuOpenPacket(preSaleInfo);
            sellingToPlayer.get().sendPacket(packet);
            return ResponseFactory.success(I18n.getLabel("horse.sell.waiting-for-confirm", sellingToPlayer.get().getIgn(), horse.getName()));
        }
        return ResponseFactory.fail(I18n.getLabel("player.not-online"));
    }

    @Override
    public Response confirmHorseSell(OnlinePlayer playerBuying, int horseId, String newName) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        ECPlayer currentOwner = horse.getOwner();
        if (currentOwner.isOnline()) {
            try {
                String previousIdentifier = horse.getName();
                HorseSaleResponse horseSellResponse = this.horseSellSession.sellHorse(horse, playerBuying);
                horse.getCommandExecutor().execute(new UpdateHorseNameCommand(playerBuying, newName));
                currentOwner.sendMessage(I18n.getLabel("horse.sell.your-horse-sold", previousIdentifier, playerBuying.getIgn(), EconomyUtilities.formatCurrency(horseSellResponse.value()), EconomyUtilities.formatCurrency(horseSellResponse.oldOwnerBalance())));
                return ResponseFactory.success(I18n.getLabel("horse.sell.horse-bought", newName, currentOwner.getIgn(), EconomyUtilities.formatCurrency(horseSellResponse.value()), EconomyUtilities.formatCurrency(horseSellResponse.newOwnerBalance())));
            }
            catch (HorseSellException ex) {
                Response response = ResponseFactory.fail(I18n.getLabel("horse.sell.cannot-sell"), ex);
                currentOwner.showResponse(response);
                return response;
            }
        }
        return ResponseFactory.fail(I18n.getLabel("horse.sell.cannot-sell"), I18n.getLabel("player.not-online"));
    }

    @Override
    public Response cancelSelling(OnlinePlayer playerBuying, int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        String message = I18n.getLabel("horse.sell.cancelled", playerBuying.getIgn(), horse.getName());
        horse.getOwner().notify(message);
        return ResponseFactory.success(I18n.getLabel(message));
    }
}

