/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.social;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.horse.social.HorsePlayAction;
import com.equestricraft.mod.horse.social.JumpPlayAction;
import com.equestricraft.mod.horse.social.MutualGroomPlayAction;
import com.equestricraft.mod.horse.social.RunTogetherPlayAction;
import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HorseInitiateHorsePlayGoal
extends AbstractHorseGoal {
    private EntityHorse friend = null;
    private Phase nextPhase = null;
    private Phase activePhase = null;
    private long lastInteractionCheck = 0L;

    public HorseInitiateHorsePlayGoal(EntityHorse horse) {
        super(horse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.JUMP));
    }

    public void setFriend(EntityHorse friend) {
        this.friend = friend;
    }

    @Override
    public boolean shouldRun() {
        return FeatureFlag.RELATIONSHIPS.isEnabled() && !this.entityHorse.m_20160_() && (this.friend != null || this.wantsToFindFriend());
    }

    private boolean wantsToFindFriend() {
        if (DateUtils.secondsSince(this.lastInteractionCheck) <= 120) {
            return false;
        }
        try {
            Optional<Duration> durationSinceLastFriendInteraction = this.entityHorse.getHorseData().getRelationships().getLastInteractionWithAnyFriend();
            boolean bl = (durationSinceLastFriendInteraction.isEmpty() || durationSinceLastFriendInteraction.get().toHours() >= 1L) && this.entityHorse.m_21187_().nextFloat() <= 0.01f;
            return bl;
        }
        finally {
            this.lastInteractionCheck = System.currentTimeMillis();
        }
    }

    @Override
    public void startGoal() {
        this.entityHorse.m_21573_().m_26573_();
        this.activePhase = this.friend != null ? new WalkTowards() : new FindFriend();
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.m_8036_() && this.activePhase != null;
    }

    @Override
    public void tickGoal() {
        boolean endPhase = this.activePhase.tick();
        if (endPhase) {
            this.activePhase.stop();
            if (this.nextPhase != null) {
                this.activePhase = this.nextPhase;
                this.activePhase.start();
                this.nextPhase = null;
            } else {
                this.activePhase = null;
            }
        }
    }

    @Override
    public void stopGoal() {
        this.activePhase = null;
        this.friend = null;
    }

    private abstract class Phase {
        private Phase() {
        }

        void start() {
        }

        abstract boolean tick();

        void stop() {
        }
    }

    public class WalkTowards
    extends Phase {
        @Override
        boolean tick() {
            Vec3 pos = HorseInitiateHorsePlayGoal.this.friend.m_20182_();
            HorseInitiateHorsePlayGoal.this.entityHorse.m_21566_().m_6849_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1.0);
            return HorseInitiateHorsePlayGoal.this.entityHorse.m_20182_().m_82554_(pos) <= 2.0;
        }

        @Override
        void stop() {
            HorseInitiateHorsePlayGoal.this.nextPhase = new Play();
        }
    }

    public class FindFriend
    extends Phase {
        private long phaseAge = 0L;

        @Override
        boolean tick() {
            if (this.phaseAge >= 100L) {
                return true;
            }
            if (HorseInitiateHorsePlayGoal.this.friend != null) {
                return true;
            }
            List nearbyHorses = ((HorseInitiateHorsePlayGoal)HorseInitiateHorsePlayGoal.this).entityHorse.f_19853_.m_45971_(EntityHorse.class, TargetingConditions.m_148353_(), (LivingEntity)HorseInitiateHorsePlayGoal.this.entityHorse, new AABB(HorseInitiateHorsePlayGoal.this.entityHorse.m_142538_()).m_82400_(30.0));
            Optional<EntityHorse> nearbyFriend = nearbyHorses.stream().filter(h -> h.getHorseData() != null).filter(h -> HorseInitiateHorsePlayGoal.this.entityHorse.getHorseData().getRelationships().offerInteraction(h.getHorseData())).findFirst();
            ++this.phaseAge;
            if (nearbyFriend.isPresent()) {
                HorseInitiateHorsePlayGoal.this.friend = nearbyFriend.get();
                return true;
            }
            return false;
        }

        @Override
        public void stop() {
            if (HorseInitiateHorsePlayGoal.this.friend != null) {
                HorseInitiateHorsePlayGoal.this.nextPhase = new WalkTowards();
            }
        }
    }

    public class Play
    extends Phase {
        private final HorsePlayAction action = this.decideRandomPlayAction();

        @Override
        void start() {
            if (this.action != null) {
                HorseInitiateHorsePlayGoal.this.entityHorse.getPlayActionGoal().setPlayAction(this.action);
                HorseInitiateHorsePlayGoal.this.friend.getPlayActionGoal().setPlayAction(this.action);
            }
        }

        @Override
        boolean tick() {
            return true;
        }

        @Override
        void stop() {
            HorseInitiateHorsePlayGoal.this.entityHorse.getHorseData().getRelationships().createInteractionWithHorse(HorseInitiateHorsePlayGoal.this.friend.getHorseData(), 5.0);
            HorseInitiateHorsePlayGoal.this.friend.getHorseData().getRelationships().createInteractionWithHorse(HorseInitiateHorsePlayGoal.this.entityHorse.getHorseData(), 5.0);
            HorseInitiateHorsePlayGoal.this.nextPhase = null;
        }

        private HorsePlayAction decideRandomPlayAction() {
            List<RunTogetherPlayAction> actions = List.of(new JumpPlayAction(), new MutualGroomPlayAction(), new RunTogetherPlayAction());
            if ((actions = actions.stream().toList()).isEmpty()) {
                return null;
            }
            return ListUtils.getRandomItem(actions);
        }
    }
}

