/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.social;

import com.equestricraft.mod.client.horse.EntityHorse;
import java.util.ArrayList;
import java.util.List;

public abstract class HorsePlayAction {
    final List<EntityHorse> horses = new ArrayList<EntityHorse>();
    Long startTime;

    public void addHorse(EntityHorse horse) {
        this.horses.add(horse);
        if (this.isStarted()) {
            this.startHorse(horse);
        } else {
            this.start();
        }
    }

    public boolean canUse() {
        return true;
    }

    public final boolean isStarted() {
        return this.startTime != null;
    }

    public final void start() {
        if (this.canUse()) {
            this.startTime = System.currentTimeMillis();
            this.onStart();
        }
    }

    public void startHorse(EntityHorse horse) {
    }

    void onStart() {
    }

    public final void tick() {
        this.horses.forEach(this::tickHorse);
    }

    public abstract void tickHorse(EntityHorse var1);

    public abstract boolean isDone();
}

