/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.social;

import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.social.HorsePlayAction;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RunTogetherPlayAction
extends HorsePlayAction {
    private Vec3 targetPosition = null;
    private boolean horseHasReached = false;

    @Override
    public boolean canUse() {
        return this.horses.size() >= 2;
    }

    @Override
    void onStart() {
        EntityHorse horse = (EntityHorse)this.horses.get(0);
        this.targetPosition = this.getRandomTargetPosition(horse);
    }

    private Vec3 getRandomTargetPosition(EntityHorse horse) {
        int xzRange = HorseSettings.getMaximumRandomWanderDistance();
        int yRange = 7;
        return LandRandomPos.m_148488_((PathfinderMob)horse, (int)xzRange, (int)yRange);
    }

    @Override
    public void startHorse(EntityHorse horse) {
        horse.m_21573_().m_26573_();
        Path path = horse.m_21573_().m_26524_(this.targetPosition.m_7096_(), this.targetPosition.m_7098_(), this.targetPosition.m_7094_(), 1);
        horse.m_21573_().m_26536_(path, 1.0);
    }

    @Override
    public void tickHorse(EntityHorse horse) {
        if (horse.m_21573_().m_26571_()) {
            this.horseHasReached = true;
        }
    }

    @Override
    public boolean isDone() {
        return this.horseHasReached;
    }
}

