/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.speed;

import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.mod.packet.ClientBoundHorseSpeedDroppingSoonUpdatePacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Timer;
import java.util.TimerTask;

public class HorseSpeedDecreaseHandler {
    private final EQHorse horse;
    private ScheduledTask currentTask = null;
    private static final Timer timer = new Timer(ThreadUtils.threadName("horse-speed-reduction"));

    public HorseSpeedDecreaseHandler(EQHorse horse) {
        this.horse = horse;
    }

    public synchronized void schedule(final OnlinePlayer player, final Runnable action) {
        TimerTask cancelTask = new TimerTask(){

            @Override
            public void run() {
                action.run();
            }
        };
        TimerTask warningTask = new TimerTask(cancelTask){
            final /* synthetic */ 1 val$cancelTask;
            {
                this.val$cancelTask = var3_3;
            }

            @Override
            public void run() {
                ClientBoundHorseSpeedDroppingSoonUpdatePacket packet = new ClientBoundHorseSpeedDroppingSoonUpdatePacket(true);
                player.sendPacket(packet);
                timer.schedule((TimerTask)this.val$cancelTask, 1000L * (long)HorseSettings.getSpeedReductionWarningSeconds().intValue());
            }
        };
        float controlValue = this.horse.getControl().getControlValue();
        long milliseconds = (long)((double)((long)HorseSettings.getSpeedReductionSeconds().intValue() * 1000L) * (double)controlValue);
        timer.schedule(warningTask, milliseconds);
        this.currentTask = new ScheduledTask(warningTask, cancelTask, action);
    }

    public void reschedule(OnlinePlayer player) {
        Runnable action = this.cancel();
        if (action != null) {
            this.schedule(player, action);
        }
    }

    public synchronized Runnable cancel() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            return this.currentTask.runnable();
        }
        return null;
    }

    private record ScheduledTask(TimerTask warningTask, TimerTask cancelTask, Runnable runnable) {
        void cancel() {
            this.warningTask.cancel();
            this.cancelTask.cancel();
        }
    }
}

