/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.speed;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.gait.Gallop;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseGait;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.gait.Reverse;
import com.equestricraft.core.skill.Skill;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.speed.HorseSpeedService;
import com.equestricraft.mod.horse.speed.policy.HorseSpeedControlPolicy;
import com.equestricraft.mod.packet.ClientBoundHorseSpeedDroppingSoonUpdatePacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

public class HorseSpeedServiceImpl
implements HorseSpeedService {
    @Override
    public void processGaitIncreaseInput(EntityHorse horseEntity, OnlinePlayer player) {
        HorseSubGait horseGait = horseEntity.getGait();
        if (horseGait == Reverse.DEFAULT) {
            this.haltHorse(horseEntity, player);
        } else if (horseGait == Gallop.FULL) {
            this.incrementHorseGait(horseEntity, player);
        } else if (FeatureFlag.ADVANCED_SPEED_CONTROL.isEnabled()) {
            if (player.doublePressDetector().processPress() == 2) {
                this.incrementHorseGait(horseEntity, player);
            } else {
                horseEntity.getSpeedDecreaseHandler().reschedule(player);
                ClientBoundHorseSpeedDroppingSoonUpdatePacket packet = new ClientBoundHorseSpeedDroppingSoonUpdatePacket(false);
                player.sendPacket(packet);
            }
        } else {
            this.incrementHorseGait(horseEntity, player);
        }
    }

    @Override
    public void incrementHorseGait(EntityHorse horseEntity, OnlinePlayer player) {
        if (this.wasLastIncreaseInputTooRecently(horseEntity)) {
            return;
        }
        HorseGait nextGait = horseEntity.getSpeedControlPolicy().getNextGait(horseEntity);
        this.setHorseSpeed(horseEntity, nextGait.getDefaultGait(), player, true, true);
        horseEntity.setLastSpeedIncreaseInput(System.currentTimeMillis());
    }

    private boolean wasLastIncreaseInputTooRecently(EntityHorse horseEntity) {
        long lastIncreaseTime = horseEntity.getLastSpeedIncreaseInput();
        long millisSince = DateUtils.millisSince(lastIncreaseTime);
        return millisSince < horseEntity.getSpeedControlPolicy().getControlInputDelay(horseEntity).toMillis();
    }

    @Override
    public void decrementHorseGait(EntityHorse horseEntity, OnlinePlayer player) {
        HorseGait previousGait = horseEntity.getSpeedControlPolicy().getPreviousGait(horseEntity);
        this.setHorseSpeed(horseEntity, previousGait.getDefaultGait(), player, false, true);
    }

    @Override
    public void setHigherGaitSpeed(EntityHorse horseEntity, OnlinePlayer player) {
        HorseSubGait next = horseEntity.getGait().getMainGait().getHighestGait();
        this.setHorseSpeed(horseEntity, next, player, true, true);
        horseEntity.setLastSpeedIncreaseInput(System.currentTimeMillis());
    }

    @Override
    public void setLowerGaitSpeed(EntityHorse horseEntity, OnlinePlayer player) {
        HorseSubGait previous = horseEntity.getGait().getMainGait().getLowestGait();
        this.setHorseSpeed(horseEntity, previous, player, false, false);
    }

    @Override
    public void setHorseSpeed(EntityHorse horseEntity, HorseSubGait gait) {
        this.setHorseSpeed(horseEntity, gait, null, false, false);
    }

    @Override
    public void cancelGallop(EntityHorse horse, OnlinePlayer player) {
        if (horse.getGait() == Gallop.FULL) {
            this.decrementHorseGait(horse, player);
        }
    }

    @Override
    public void haltHorse(EntityHorse horse, OnlinePlayer player) {
        this.setHorseSpeed(horse, Halt.DEFAULT, player, false, false);
    }

    @Override
    public void checkSideStepping(EntityHorse horse, OnlinePlayer player) {
        if (player.getSkills().hasSkill(Skill.SIDE_STEPPING)) {
            HorseSpeedControlPolicy speedControlPolicy = horse.getSpeedControlPolicy();
            if (speedControlPolicy.canSideStep(horse)) {
                horse.setMaximumSideSteppingSpeed(speedControlPolicy.getMaximumSideSteppingSpeed(horse));
                return;
            }
            player.sendToast(I18n.getLabel("horse.side-step.skill-not-learned.horse"));
        } else {
            player.sendToast(I18n.getLabel("horse.side-step.skill-not-learned.player"));
        }
        horse.setMaximumSideSteppingSpeed(0.0f);
    }

    private void setHorseSpeed(EntityHorse horseEntity, HorseSubGait gait, OnlinePlayer ridingPlayer, boolean applyLimits, boolean scheduleReduction) {
        HorseSpeedControlPolicy speedControlPolicy = horseEntity.getSpeedControlPolicy();
        if (applyLimits) {
            Optional<Object> speedLimit;
            Optional<Object> optional = speedLimit = ridingPlayer != null ? ridingPlayer.getSpeedLimit() : Optional.empty();
            if (speedLimit.isPresent() && gait.getBlocksPerSecond() > ((Float)speedLimit.get()).floatValue()) {
                ridingPlayer.sendToast(I18n.getLabel("horse.speed.restricted"));
                return;
            }
            if (!speedControlPolicy.isWarmedUpForGait(horseEntity, gait)) {
                if (ridingPlayer != null) {
                    ridingPlayer.sendToast(I18n.getLabel("horse.speed.not-warmed-up", gait.getName().toLowerCase()));
                }
                return;
            }
        }
        horseEntity.getSpeedDecreaseHandler().cancel();
        speedControlPolicy.onGaitChange(horseEntity, gait);
        TaskScheduler.executeAwaitSyncTask(() -> horseEntity.setGait(gait));
        if (ridingPlayer != null) {
            ridingPlayer.getDisplay().getCurrentGait().showGait(gait);
        }
        if (scheduleReduction && ridingPlayer != null && FeatureFlag.ADVANCED_SPEED_CONTROL.isEnabled() && gait.getBlocksPerSecond() > 0.0f && gait != Gallop.FULL) {
            horseEntity.getSpeedDecreaseHandler().schedule(ridingPlayer, () -> this.decrementHorseGait(horseEntity, ridingPlayer));
        }
    }
}

