/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.speed.policy;

import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.gait.HorseGait;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.ride.HorseCurrentRide;
import com.equestricraft.core.skill.Skill;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.speed.policy.HorseSpeedControlPolicy;
import java.time.Duration;

public class StandardHorseSpeedControlPolicy
extends HorseSpeedControlPolicy {
    @Override
    public HorseGait getNextGait(EntityHorse horse) {
        HorseGait current = horse.getGait().getMainGait();
        return current.getNext();
    }

    @Override
    public HorseGait getPreviousGait(EntityHorse horse) {
        HorseGait current = horse.getGait().getMainGait();
        return current.getPrevious();
    }

    @Override
    public Duration getControlInputDelay(EntityHorse horse) {
        int zeroControlSeconds = HorseSettings.getSpeedIncreaseDelaySecondsNoControl();
        int fullControlSeconds = HorseSettings.getSpeedIncreaseDelaySecondsFullControl();
        double controlValue = horse.getHorseData().getControl().getControlValue();
        long millis = (long)(((double)fullControlSeconds + (1.0 - controlValue) * (double)(zeroControlSeconds - fullControlSeconds)) * 1000.0);
        return Duration.ofMillis(millis);
    }

    @Override
    public boolean isWarmedUpForGait(EntityHorse horse, HorseSubGait gait) {
        return horse.getHorseData().getWarmUp().isWarmedUpForGait(gait);
    }

    @Override
    public boolean canSideStep(EntityHorse horse) {
        return horse.getHorseData().getSkill().hasSkill(Skill.SIDE_STEPPING);
    }

    @Override
    public float getMaximumSideSteppingSpeed(EntityHorse horse) {
        return 0.5f * horse.getHorseData().getControl().getSteeringValue();
    }

    @Override
    public void onGaitChange(EntityHorse horse, HorseSubGait gait) {
        HorseCurrentRide currentRide = horse.getHorseData().getCurrentRide().getCurrentRide();
        if (currentRide != null) {
            currentRide.startNewTimeBlock(gait);
        }
    }
}

