/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.speedpolicy;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.stats.HorseStat;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.speedpolicy.HorseSpeedPolicy;

public class StandardHorseSpeedPolicy
extends HorseSpeedPolicy {
    @Override
    public float getSpeed(EntityHorse entityHorse) {
        float speed = entityHorse.getBaseSpeed();
        EQHorse horseData = entityHorse.getHorseData();
        if (horseData != null) {
            HorseSubGait currentGait = entityHorse.getGait();
            long stamina = horseData.getStamina().getPoints();
            speed *= this.calculateSpeedValue(horseData.getStamina().getValue());
            if (FeatureFlag.STAMINA.isEnabled() && stamina <= currentGait.getRearStamina() && entityHorse.m_20160_()) {
                entityHorse.negativeRideEnd(I18n.getLabel("horse.eject.stamina"));
                entityHorse.getHorseData().getFrustration().increment(this.determineFrustrationFromStaminaDrain(horseData));
            }
        }
        return speed;
    }

    private float determineFrustrationFromStaminaDrain(EQHorse horse) {
        int ageMonths = horse.getAge().getMonths();
        if (ageMonths <= 12) {
            return 0.3f;
        }
        if (ageMonths <= 24) {
            return 0.2f;
        }
        return 0.1f;
    }

    private float calculateSpeedValue(float stamina) {
        if (stamina >= 0.8f) {
            return 1.0f;
        }
        if (stamina <= 0.0f) {
            return 0.4f;
        }
        return (float)((double)(0.4f + 1.25f * stamina) - (double)0.00625f * Math.pow(stamina, 2.0));
    }

    @Override
    public HorseStat getSpeed(EntityHorse entityHorse, HorseSubGait gait) {
        return entityHorse.getHorseData().getSpeed().getStat(gait);
    }
}

