/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.stayput;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.instruction.HorseInstruction;
import com.equestricraft.core.horse.instruction.HorseInstructionProvider;
import com.equestricraft.core.horse.instruction.HorseInstructionState;
import com.equestricraft.core.horse.instruction.HorseInstructionType;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import java.util.Optional;

public class HorseStayPutInstruction
extends HorseInstruction {
    @Service
    private static StandardHorseEntitySession standardHorseEntitySession;
    private EntityHorse entity = null;

    private HorseStayPutInstruction(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getInstructionLabel() {
        return switch (this.getState()) {
            default -> throw new IncompatibleClassChangeError();
            case HorseInstructionState.ACTIVE -> I18n.getLabel("horse.instruction.stay.stop.label");
            case HorseInstructionState.INACTIVE -> I18n.getLabel("horse.instruction.stay.start.label");
        };
    }

    @Override
    public HorseInstructionType getType() {
        return HorseInstructionType.STAY;
    }

    @Override
    protected void onStart(ECPlayer player) {
        Optional<EntityHorse> horse = standardHorseEntitySession.findEntityForHorse(this.horse);
        if (horse.isPresent()) {
            this.entity = horse.get();
            this.entity.setFreeze(true);
        }
    }

    @Override
    protected void onStop(ECPlayer player) {
        this.entity.setFreeze(false);
    }

    @Override
    public HorseInstructionState getState() {
        return this.entity != null && this.entity.isFreeze() ? HorseInstructionState.ACTIVE : HorseInstructionState.INACTIVE;
    }

    public static class Provider
    implements HorseInstructionProvider {
        @Override
        public HorseInstructionType getType() {
            return HorseInstructionType.STAY;
        }

        @Override
        public <T extends HorseInstruction> T getInstruction(EQHorse horse) {
            return (T)new HorseStayPutInstruction(horse);
        }
    }
}

