/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.stud;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.InvalidGenderException;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.horse.stud.HorseStudRegisterPage;
import com.equestricraft.core.horse.stud.HorseStudRegisterPageService;
import com.equestricraft.core.horse.stud.HorseStudRegisterSortOrder;
import com.equestricraft.core.horse.stud.StudAlreadyRegisteredException;
import com.equestricraft.core.horse.stud.StudNotRegisteredException;
import com.equestricraft.core.horse.stud.StudRegistrationResponse;
import com.equestricraft.core.horse.stud.StudRegistrationStatus;
import com.equestricraft.core.horse.stud.StudRenewalResponse;
import com.equestricraft.core.horse.stud.StudRequirementCheckException;
import com.equestricraft.core.studregistry.StudRegistry;
import com.equestricraft.core.studregistry.StudRegistrySession;
import com.equestricraft.core.studregistry.StudRegistrySimple;
import com.equestricraft.mod.horse.stud.HorseStudRegisterService;
import com.equestricraft.mod.packet.ClientBoundHorseStudRegisterMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundStudRegisterListOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;

public class HorseStudRegisterServiceImpl
implements HorseStudRegisterService {
    @Service
    private HorseStudRegisterPageService horseStudRegisterPageService;
    @Service
    private StudRegistrySession studRegistrySession;
    @Service
    private HorseRepository horseRepository;

    @Override
    public Response registerStud(OnlinePlayer onlinePlayer, int horseId, int groupId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        HorsePermissionChecker.ensureHasPermissionLevel(onlinePlayer, horse, HorsePermissionLevel.OWNER);
        try {
            StudRegistrationResponse response = horse.getStudRegistration().register(groupId);
            return ResponseFactory.success(I18n.getLabel("horse.stud-registration.register.success.title"), I18n.getLabel("horse.stud-registration.register.success.message", response.groupName(), response.daysUntilRenewal(), response.newBalance()));
        }
        catch (EconomyException | InvalidGenderException | StudAlreadyRegisteredException | StudRequirementCheckException ex) {
            return ResponseFactory.fail(ex);
        }
    }

    @Override
    public Response renewRegistration(OnlinePlayer onlinePlayer, int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        HorsePermissionChecker.ensureHasPermissionLevel(onlinePlayer, horse, HorsePermissionLevel.OWNER);
        try {
            StudRenewalResponse response = horse.getStudRegistration().renew();
            return ResponseFactory.success(I18n.getLabel("horse.stud-registration.renew.success.title"), I18n.getLabel("horse.stud-registration.renew.success.message", response.daysUntilRenewal(), response.newBalance()));
        }
        catch (EconomyException | InvalidGenderException | StudNotRegisteredException | StudRequirementCheckException ex) {
            return ResponseFactory.fail(ex);
        }
    }

    @Override
    public Response removeRegistration(OnlinePlayer onlinePlayer, int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        HorsePermissionChecker.ensureHasPermissionLevel(onlinePlayer, horse, HorsePermissionLevel.OWNER);
        try {
            horse.getStudRegistration().remove();
            return ResponseFactory.success(I18n.getLabel("horse.stud-registration.remove.success.title"), I18n.getLabel("horse.stud-registration.remove.success.message"));
        }
        catch (StudNotRegisteredException ex) {
            return ResponseFactory.fail(ex);
        }
    }

    @Override
    public Response showRegister(OnlinePlayer onlinePlayer, int registryId, HorseStudRegisterSortOrder sortOrder, SortDirection sortDirection, int pageNumber) {
        HorseStudRegisterPage page = this.horseStudRegisterPageService.retrieveStudRegister(sortOrder, sortDirection, pageNumber);
        StudRegistrySimple registry = this.studRegistrySession.retrieveRegistry(registryId);
        ClientBoundStudRegisterListOpenPacket packet = new ClientBoundStudRegisterListOpenPacket(registry, page);
        onlinePlayer.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response showManageMenu(OnlinePlayer player, StudRegistry registry) {
        EQHorse selectedHorse = player.getHorses().getSelected().orElse(null);
        StudRegistrationStatus status = null;
        if (selectedHorse != null) {
            status = selectedHorse.getStudRegistration().getStatus();
        }
        ClientBoundHorseStudRegisterMenuOpenPacket packet = new ClientBoundHorseStudRegisterMenuOpenPacket(selectedHorse != null ? Integer.valueOf(selectedHorse.getId()) : null, registry.getId(), registry.getName(), status);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }
}

