/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.tack;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.tack.TackType;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.tack.HorseTackAccessor;
import com.equestricraft.core.horse.tack.HorseTackService;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.tack.HorseTackInfo;
import com.equestricraft.core.player.tack.TackInventoryItem;
import com.equestricraft.core.player.tack.TackInventoryItemInfo;
import com.equestricraft.core.player.tack.TackInventorySession;
import com.equestricraft.core.tack.Tack;
import com.equestricraft.core.tack.TackInfo;
import com.equestricraft.core.tack.TackTransformer;
import com.equestricraft.core.tack.TackTypeInfo;
import com.equestricraft.core.tack.bonnet.HorseBonnet;
import com.equestricraft.core.tack.boots.HorseBoots;
import com.equestricraft.core.tack.bridle.HorseBridle;
import com.equestricraft.core.tack.cinch.HorseCinch;
import com.equestricraft.core.tack.girth.HorseGirth;
import com.equestricraft.core.tack.halter.HorseHalter;
import com.equestricraft.core.tack.pad.HorsePad;
import com.equestricraft.core.tack.rein.HorseRein;
import com.equestricraft.core.tack.saddle.HorseSaddle;
import com.equestricraft.core.tack.wraps.HorseWraps;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.horse.tack.HorseTackTypeInfo;
import com.equestricraft.mod.horse.tack.TackTypesInfo;
import com.equestricraft.mod.packet.ClientBoundHorseTackMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;
import java.util.UUID;

public class HorseTackServiceImpl
implements HorseTackService {
    @Service
    private TackTransformer tackTransformer;
    @Service
    private HorseRepository horseRepository;
    @Service
    private StandardHorseEntitySession standardHorseEntitySession;
    @Service
    private TackInventorySession tackInventorySession;

    @Override
    public void showHorseTackMenu(ECPlayer player, EQHorse horse) {
        TackTypesInfo types = this.getTackInfoForHorse(horse);
        ClientBoundHorseTackMenuOpenPacket packet = new ClientBoundHorseTackMenuOpenPacket(horse.getId(), types);
        player.sendPacket(packet);
    }

    private TackTypesInfo getTackInfoForHorse(EQHorse horse) {
        HorseTackTypeInfo bonnet = this.buildTypeInfoForHorse(TackType.BONNET, horse);
        HorseTackTypeInfo boots = this.buildTypeInfoForHorse(TackType.BOOTS, horse);
        HorseTackTypeInfo bridle = this.buildTypeInfoForHorse(TackType.BRIDLE, horse);
        HorseTackTypeInfo cinch = this.buildTypeInfoForHorse(TackType.CINCH, horse);
        HorseTackTypeInfo girth = this.buildTypeInfoForHorse(TackType.GIRTH, horse);
        HorseTackTypeInfo pad = this.buildTypeInfoForHorse(TackType.PAD, horse);
        HorseTackTypeInfo halter = this.buildTypeInfoForHorse(TackType.HALTER, horse);
        HorseTackTypeInfo rein = this.buildTypeInfoForHorse(TackType.REIN, horse);
        HorseTackTypeInfo saddle = this.buildTypeInfoForHorse(TackType.SADDLE, horse);
        HorseTackTypeInfo wraps = this.buildTypeInfoForHorse(TackType.WRAPS, horse);
        return new TackTypesInfo(bonnet, boots, bridle, cinch, girth, pad, halter, rein, saddle, wraps);
    }

    private HorseTackTypeInfo buildTypeInfoForHorse(TackType type, EQHorse horse) {
        TackTypeInfo typeInfo = this.tackTransformer.buildTypeInfo(type);
        Optional<HorseTackInfo<?, ?>> tack = horse.getTacks().getTackForType(type);
        TackInfo tackInfo = tack.map(value -> this.tackTransformer.buildInfo((Tack)value.tack())).orElse(null);
        Double wearPercentage = tack.map(HorseTackInfo::getConditionPercentage).orElse(null);
        return new HorseTackTypeInfo(typeInfo, tackInfo, tack.map(HorseTackInfo::inventoryItem).map(TackInventoryItem::getUuid).orElse(null), wearPercentage);
    }

    @Override
    public Response setTackOnHorse(ECPlayer player, int horseId, UUID id) {
        OnlinePlayer onlinePlayer;
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Optional<EntityHorse> entity = this.standardHorseEntitySession.findEntityForHorse(horse, (onlinePlayer = player.require(OnlinePlayer.class)).getServerLevel());
        if (entity.isPresent()) {
            this.setTackOnHorse(horse, entity.get(), id);
            Optional<TackInventoryItem> item = this.tackInventorySession.findInventoryItem(id);
            if (item.isPresent()) {
                TackInventoryItemInfo tack = this.tackInventorySession.getInventoryItem(id);
                item.get().setFitQuality(this.getUntrainedPercentage(tack.tack()));
                item.get().save();
            }
            return ResponseFactory.success();
        }
        return ResponseFactory.fail(I18n.getLabel("horse.tack-menu.title"), I18n.getLabel("horse.tack.horse-gone"));
    }

    private int getUntrainedPercentage(Tack tack) {
        return NumberUtils.randomIntInRange(tack.getMinimumUntrainedFitQuality(), tack.getMaximumUntrainedFitQuality());
    }

    @Override
    public Response setTackOnHorse(EQHorse horse, TackType tackType, int id) {
        Optional<EntityHorse> entity = this.standardHorseEntitySession.findEntityForHorse(horse);
        if (entity.isPresent()) {
            TackInventoryItem item = this.tackInventorySession.addItemToInventory(horse.getOwner(), tackType, id);
            item.setFitQuality(100.0);
            item.save();
            this.setTackOnHorse(horse, entity.get(), item.getUuid());
            return ResponseFactory.success();
        }
        return ResponseFactory.fail(I18n.getLabel("horse.tack-menu.title"), I18n.getLabel("horse.tack.horse-gone"));
    }

    private void setTackOnHorse(EQHorse horse, EntityHorse entity, UUID id) {
        TackInventoryItemInfo info2 = this.tackInventorySession.getInventoryItem(id);
        for (ItemTag itemTag : info2.tack().getTags()) {
            double valueForTag;
            if (itemTag.getRejectThreshold() == null || !((valueForTag = horse.getTags().getValueForTag(itemTag.getTagId())) <= itemTag.getRejectThreshold())) continue;
            return;
        }
        this.persistSelection(horse, entity, info2.tack(), id);
    }

    private void persistSelection(EQHorse horse, EntityHorse entity, Tack tack, UUID id) {
        HorseTackAccessor horsesTack = horse.getTacks();
        if (tack instanceof HorseBonnet) {
            horse.setBonnetItemId(id);
            entity.setBonnetModel(horsesTack.getBonnet().map(HorseTackInfo::tack).map(HorseBonnet::getModel).orElse(null));
        } else if (tack instanceof HorseBoots) {
            horse.setBootsItemId(id);
            entity.setBootsModel(horsesTack.getBoots().map(HorseTackInfo::tack).map(HorseBoots::getModel).orElse(null));
        } else if (tack instanceof HorseBridle) {
            horse.setBridleItemId(id);
            entity.setBridleModel(horsesTack.getBridle().map(HorseTackInfo::tack).map(HorseBridle::getModel).orElse(null));
        } else if (tack instanceof HorseCinch) {
            horse.setCinchItemId(id);
            entity.setCinchModel(horsesTack.getCinch().map(HorseTackInfo::tack).map(HorseCinch::getModel).orElse(null));
        } else if (tack instanceof HorseGirth) {
            horse.setGirthItemId(id);
            entity.setGirthModel(horsesTack.getGirth().map(HorseTackInfo::tack).map(HorseGirth::getModel).orElse(null));
        } else if (tack instanceof HorseHalter) {
            horse.setHalterItemId(id);
            entity.setHalterModel(horsesTack.getHalter().map(HorseTackInfo::tack).map(HorseHalter::getModel).orElse(null));
        } else if (tack instanceof HorsePad) {
            horse.setPadItemId(id);
            entity.setPadModel(horsesTack.getPad().map(HorseTackInfo::tack).map(HorsePad::getModel).orElse(null));
        } else if (tack instanceof HorseRein) {
            horse.setReinItemId(id);
            entity.setReinModel(horsesTack.getRein().map(HorseTackInfo::tack).map(HorseRein::getModel).orElse(null));
        } else if (tack instanceof HorseSaddle) {
            horse.setSaddleItemId(id);
            entity.setSaddleModel(horsesTack.getSaddle().map(HorseTackInfo::tack).map(HorseSaddle::getModel).orElse(null));
        } else if (tack instanceof HorseWraps) {
            horse.setWrapsItemId(id);
            entity.setWrapsModel(horsesTack.getWraps().map(HorseTackInfo::tack).map(HorseWraps::getModel).orElse(null));
        } else {
            throw new IllegalArgumentException(String.format("Invalid tack type: %s", tack.getClass().getName()));
        }
        horse.save();
    }

    @Override
    public Response removeTackFromHorse(int horseId, TackType type) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        EntityHorse entity = this.standardHorseEntitySession.findEntityForHorse(horse).orElseThrow();
        switch (type) {
            case BONNET: {
                horse.setBonnetItemId(null);
                entity.setBonnetModel(null);
                break;
            }
            case BOOTS: {
                horse.setBootsItemId(null);
                entity.setBootsModel(null);
                break;
            }
            case BRIDLE: {
                horse.setBridleItemId(null);
                entity.setBridleModel(null);
                break;
            }
            case CINCH: {
                horse.setCinchItemId(null);
                entity.setCinchModel(null);
                break;
            }
            case GIRTH: {
                horse.setGirthItemId(null);
                entity.setGirthModel(null);
                break;
            }
            case HALTER: {
                horse.setHalterItemId(null);
                entity.setHalterModel(null);
                break;
            }
            case PAD: {
                horse.setPadItemId(null);
                entity.setPadModel(null);
                break;
            }
            case REIN: {
                horse.setReinItemId(null);
                entity.setReinModel(null);
                break;
            }
            case SADDLE: {
                horse.setSaddleItemId(null);
                entity.setSaddleModel(null);
                break;
            }
            case WRAPS: {
                horse.setWrapsItemId(null);
                entity.setWrapsModel(null);
            }
        }
        horse.save();
        return ResponseFactory.success();
    }
}

